/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.lookup;

import network.oxalis.vefa.peppol.common.lang.PeppolLoadingException;
import network.oxalis.vefa.peppol.lookup.LookupClient;
import network.oxalis.vefa.peppol.lookup.api.MetadataFetcher;
import network.oxalis.vefa.peppol.lookup.api.MetadataLocator;
import network.oxalis.vefa.peppol.lookup.api.MetadataProvider;
import network.oxalis.vefa.peppol.lookup.api.MetadataReader;
import network.oxalis.vefa.peppol.mode.Mode;
import network.oxalis.vefa.peppol.security.api.CertificateValidator;
import network.oxalis.vefa.peppol.security.util.EmptyCertificateValidator;

public class LookupClientBuilder {
    private Mode mode;
    protected MetadataFetcher metadataFetcher;
    protected MetadataLocator metadataLocator;
    protected CertificateValidator certificateValidator = EmptyCertificateValidator.INSTANCE;
    protected MetadataProvider metadataProvider;
    protected MetadataReader metadataReader;

    public static LookupClientBuilder newInstance(Mode mode) {
        return new LookupClientBuilder(mode);
    }

    public static LookupClientBuilder forMode(Mode mode) throws PeppolLoadingException {
        return LookupClientBuilder.newInstance(mode).certificateValidator(mode.initiate("security.validator.class", CertificateValidator.class));
    }

    public static LookupClientBuilder forMode(String modeIdentifier) throws PeppolLoadingException {
        return LookupClientBuilder.forMode(Mode.of(modeIdentifier));
    }

    public static LookupClientBuilder forProduction() throws PeppolLoadingException {
        return LookupClientBuilder.forMode("PRODUCTION");
    }

    public static LookupClientBuilder forTest() throws PeppolLoadingException {
        return LookupClientBuilder.forMode("TEST");
    }

    private LookupClientBuilder(Mode mode) {
        this.mode = mode;
    }

    public LookupClientBuilder fetcher(MetadataFetcher metadataFetcher) {
        this.metadataFetcher = metadataFetcher;
        return this;
    }

    public LookupClientBuilder fetcher(Class<? extends MetadataFetcher> metadataFetcher) throws PeppolLoadingException {
        return this.fetcher(this.mode.initiate(metadataFetcher));
    }

    public LookupClientBuilder locator(MetadataLocator metadataLocator) {
        this.metadataLocator = metadataLocator;
        return this;
    }

    public LookupClientBuilder locator(Class<? extends MetadataLocator> metadataLocator) throws PeppolLoadingException {
        return this.locator(this.mode.initiate(metadataLocator));
    }

    public LookupClientBuilder provider(MetadataProvider metadataProvider) {
        this.metadataProvider = metadataProvider;
        return this;
    }

    public LookupClientBuilder provider(Class<? extends MetadataProvider> metadataProvider) throws PeppolLoadingException {
        return this.provider(this.mode.initiate(metadataProvider));
    }

    public LookupClientBuilder reader(MetadataReader metadataReader) {
        this.metadataReader = metadataReader;
        return this;
    }

    public LookupClientBuilder reader(Class<? extends MetadataReader> metadataReader) throws PeppolLoadingException {
        return this.reader(this.mode.initiate(metadataReader));
    }

    public LookupClientBuilder certificateValidator(CertificateValidator certificateValidator) {
        this.certificateValidator = certificateValidator;
        return this;
    }

    public LookupClient build() throws PeppolLoadingException {
        if (this.metadataLocator == null) {
            this.locator(this.mode.initiate("lookup.locator.class", MetadataLocator.class));
        }
        if (this.metadataProvider == null) {
            this.provider(this.mode.initiate("lookup.provider.class", MetadataProvider.class));
        }
        if (this.metadataFetcher == null) {
            this.fetcher(this.mode.initiate("lookup.fetcher.class", MetadataFetcher.class));
        }
        if (this.metadataReader == null) {
            this.reader(this.mode.initiate("lookup.reader.class", MetadataReader.class));
        }
        return new LookupClient(this);
    }
}

