/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.lookup.locator;

import com.google.common.io.BaseEncoding;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import network.oxalis.vefa.peppol.common.model.ParticipantIdentifier;
import network.oxalis.vefa.peppol.lookup.api.LookupException;
import network.oxalis.vefa.peppol.lookup.api.NotFoundException;
import network.oxalis.vefa.peppol.lookup.locator.AbstractLocator;
import network.oxalis.vefa.peppol.lookup.util.DynamicHostnameGenerator;
import network.oxalis.vefa.peppol.lookup.util.EncodingUtils;
import network.oxalis.vefa.peppol.mode.Mode;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.NAPTRRecord;
import org.xbill.DNS.Record;
import org.xbill.DNS.TextParseException;

public class BdxlLocator
extends AbstractLocator {
    private DynamicHostnameGenerator hostnameGenerator;

    public BdxlLocator(Mode mode) {
        this(mode.getString("lookup.locator.bdxl.prefix"), mode.getString("lookup.locator.hostname"), mode.getString("lookup.locator.bdxl.algorithm"), EncodingUtils.get(mode.getString("lookup.locator.bdxl.encoding")));
    }

    public BdxlLocator(String hostname) {
        this(hostname, "SHA-256");
    }

    public BdxlLocator(String hostname, String digestAlgorithm) {
        this("", hostname, digestAlgorithm);
    }

    public BdxlLocator(String prefix, String hostname, String digestAlgorithm) {
        this(prefix, hostname, digestAlgorithm, BaseEncoding.base32());
    }

    public BdxlLocator(String prefix, String hostname, String digestAlgorithm, BaseEncoding encoding) {
        this.hostnameGenerator = new DynamicHostnameGenerator(prefix, hostname, digestAlgorithm, encoding);
    }

    @Override
    public URI lookup(ParticipantIdentifier participantIdentifier) throws LookupException {
        String hostname = this.hostnameGenerator.generate(participantIdentifier).replaceAll("=*", "");
        try {
            Lookup lookup2 = new Lookup(hostname, 35);
            Record[] records = lookup2.run();
            if (records == null) {
                if (lookup2.getResult() == 3) {
                    throw new NotFoundException(String.format("Identifier '%s' is not registered in SML.", participantIdentifier.toString()));
                }
                throw new LookupException(String.format("Error when looking up identifier '%s' in SML.", participantIdentifier.toString()));
            }
            for (Record record : records) {
                String result;
                NAPTRRecord naptrRecord = (NAPTRRecord)record;
                if (!"Meta:SMP".equals(naptrRecord.getService()) || !"U".equalsIgnoreCase(naptrRecord.getFlags()) || (result = BdxlLocator.handleRegex(naptrRecord.getRegexp(), hostname)) == null) continue;
                return URI.create(result);
            }
        }
        catch (TextParseException e) {
            throw new LookupException("Error when handling DNS lookup for BDXL.", e);
        }
        throw new NotFoundException("Record for SMP not found in SML.");
    }

    public static String handleRegex(String naptrRegex, String hostname) {
        String[] regexp = naptrRegex.split("!");
        if (".*".equals(regexp[1])) {
            return regexp[2];
        }
        Pattern pattern = Pattern.compile(regexp[1]);
        Matcher matcher = pattern.matcher(hostname);
        if (matcher.matches()) {
            return matcher.replaceAll(regexp[2].replaceAll("\\\\{2}", "\\$"));
        }
        return null;
    }
}

