/*
 * Decompiled with CFR 0.152.
 */
package eu.sendregning.oxalis;

import com.google.common.io.ByteStreams;
import com.google.inject.Key;
import com.google.inject.name.Names;
import eu.sendregning.oxalis.TransmissionParameters;
import eu.sendregning.oxalis.TransmissionResult;
import eu.sendregning.oxalis.TransmissionTask;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalDouble;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import network.oxalis.api.model.TransmissionIdentifier;
import network.oxalis.outbound.OxalisOutboundComponent;
import network.oxalis.vefa.peppol.common.model.DocumentTypeIdentifier;
import network.oxalis.vefa.peppol.common.model.Endpoint;
import network.oxalis.vefa.peppol.common.model.ParticipantIdentifier;
import network.oxalis.vefa.peppol.common.model.ProcessIdentifier;
import network.oxalis.vefa.peppol.common.model.TransportProfile;
import no.difi.certvalidator.Validator;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger log = LoggerFactory.getLogger(Main.class);
    private static OptionSpec<String> fileSpec;
    private static OptionSpec<String> sender;
    private static OptionSpec<String> recipient;
    private static OptionSpec<String> docType;
    private static OptionSpec<String> profileType;
    private static OptionSpec<File> evidencePath;
    private static OptionSpec<Boolean> useRequestFactory;
    private static OptionSpec<Integer> repeatCount;
    private static OptionSpec<String> destinationUrl;
    private static OptionSpec<File> destinationCertificate;
    private static OptionSpec<String> protocol;
    private static OptionSpec<Integer> maxTransmissions;
    private static OptionSpec<Boolean> probe;
    private static OptionSpec<String> tag;
    private static OptionSpec<Integer> sleep;

    public static void main(String[] args) throws Exception {
        Integer sleepSecs;
        int i;
        String value;
        String senderId;
        OptionSet optionSet;
        OptionParser optionParser = Main.getOptionParser();
        if (args.length == 0) {
            System.out.println();
            optionParser.printHelpOn(System.out);
            System.out.println();
            System.out.println("Configure logging: java -Dlogback.configurationFile=/path/to/config.xml -jar <this_jar_file> options");
            return;
        }
        try {
            optionSet = optionParser.parse(args);
        }
        catch (Exception e) {
            Main.printErrorMessage(e.getMessage());
            return;
        }
        OxalisOutboundComponent oxalisOutboundComponent = new OxalisOutboundComponent();
        TransmissionParameters params = new TransmissionParameters(oxalisOutboundComponent);
        File evidencePath = Main.evidencePath.value(optionSet);
        if (evidencePath == null) {
            evidencePath = new File(".");
        }
        if (!evidencePath.exists() || !evidencePath.isDirectory()) {
            Main.printErrorMessage(evidencePath + " does not exist or is not a directory");
        }
        params.setEvidencePath(evidencePath);
        params.setTag(tag.value(optionSet));
        params.setUseFactory(useRequestFactory.value(optionSet));
        String recipientId = recipient.value(optionSet);
        if (recipientId != null) {
            params.setReceiver(ParticipantIdentifier.of(recipientId));
        }
        if ((senderId = sender.value(optionSet)) != null) {
            params.setSender(ParticipantIdentifier.of(senderId));
        }
        if (docType != null && docType.value(optionSet) != null) {
            value = docType.value(optionSet);
            params.setDocType(DocumentTypeIdentifier.of(value));
        }
        if (profileType != null && profileType.value(optionSet) != null) {
            value = profileType.value(optionSet);
            params.setProcessIdentifier(ProcessIdentifier.of(value));
        }
        if (probe.value(optionSet).booleanValue()) {
            CloseableHttpClient httpClient = oxalisOutboundComponent.getInjector().getInstance(CloseableHttpClient.class);
            try (CloseableHttpResponse response = httpClient.execute(new HttpGet(destinationUrl.value(optionSet)));){
                ByteStreams.copy(response.getEntity().getContent(), System.out);
            }
        }
        if (optionSet.has(destinationUrl) && !probe.value(optionSet).booleanValue()) {
            X509Certificate certificate;
            String destinationString = destinationUrl.value(optionSet);
            try (FileInputStream inputStream = new FileInputStream(destinationCertificate.value(optionSet));){
                certificate = Validator.getCertificate(inputStream);
            }
            params.setEndpoint(Endpoint.of(TransportProfile.of(protocol.value(optionSet)), URI.create(destinationString), certificate));
        }
        String payloadFileSpec = fileSpec.value(optionSet);
        List<File> files = Main.locateFiles(payloadFileSpec);
        System.out.println();
        System.out.println();
        int repeats = optionSet.valueOf(repeatCount);
        int maximumTransmissions = optionSet.valueOf(maxTransmissions);
        ExecutorService exec = oxalisOutboundComponent.getInjector().getInstance(Key.get(ExecutorService.class, (Annotation)Names.named("default")));
        ExecutorCompletionService<TransmissionResult> ecs = new ExecutorCompletionService<TransmissionResult>(exec);
        long start = System.nanoTime();
        int submittedTaskCount = 0;
        for (File file : files) {
            if (!file.isFile() || !file.canRead()) {
                log.error("File " + file + " is not a file or can not be read, skipping...");
                continue;
            }
            for (i = 0; i < repeats; ++i) {
                TransmissionTask transmissionTask = new TransmissionTask(params, file);
                Future<TransmissionResult> submit = ecs.submit(transmissionTask);
                if (++submittedTaskCount <= maximumTransmissions) continue;
                log.info("Stopped submitting tasks at {} " + submittedTaskCount);
                break;
            }
            if (submittedTaskCount <= maximumTransmissions) continue;
            break;
        }
        ArrayList<TransmissionResult> results = new ArrayList<TransmissionResult>();
        int failed = 0;
        for (i = 0; i < submittedTaskCount; ++i) {
            try {
                Future future = ecs.take();
                TransmissionResult transmissionResult = (TransmissionResult)future.get();
                results.add(transmissionResult);
                continue;
            }
            catch (InterruptedException e) {
                System.err.println(e.getMessage());
                continue;
            }
            catch (ExecutionException e) {
                log.error("Execution failed: {}", (Object)e.getMessage(), (Object)e);
                ++failed;
            }
        }
        long elapsed = System.nanoTime() - start;
        exec.shutdownNow();
        for (TransmissionResult transmissionResult : results) {
            TransmissionIdentifier transmissionIdentifier = transmissionResult.getTransmissionIdentifier();
            System.out.println(String.format("%s transmission took %s ms", transmissionIdentifier, transmissionResult.getDuration()));
        }
        OptionalDouble average = results.stream().mapToLong(TransmissionResult::getDuration).average();
        if (average.isPresent()) {
            System.out.println("Average transmission time was " + average.getAsDouble() + "ms");
        }
        long elapsedInSeconds = TimeUnit.SECONDS.convert(elapsed, TimeUnit.NANOSECONDS);
        System.out.println("Total time spent: " + elapsedInSeconds + "s");
        System.out.println("Attempted to send " + results.size() + " files");
        System.out.println("Failed transmissions: " + failed);
        if (results.size() > 0 && elapsedInSeconds > 0L) {
            System.out.println("Transmission speed " + (long)results.size() / elapsedInSeconds + " documents per second");
        }
        if ((sleepSecs = sleep.value(optionSet)) > 0) {
            Thread.sleep(sleepSecs * 1000);
        }
        System.exit(failed == 0 ? 0 : 1);
    }

    static List<File> locateFiles(String payloadFileSpec) {
        List<File> files;
        block48: {
            files = new ArrayList<File>();
            if ("-".equals(payloadFileSpec)) {
                try (InputStreamReader reader = new InputStreamReader(System.in);
                     BufferedReader bufferedReader = new BufferedReader(reader);){
                    files = bufferedReader.lines().map(File::new).collect(Collectors.toList());
                }
                catch (IOException e) {
                    log.warn(e.getMessage(), e);
                }
            } else {
                File fileSpec = new File(payloadFileSpec);
                if (!fileSpec.exists()) {
                    log.warn(String.format("'%s' does not exists.", fileSpec.getAbsolutePath()));
                } else {
                    if (fileSpec.isDirectory()) {
                        try (DirectoryStream<Path> stream = Files.newDirectoryStream(Paths.get(payloadFileSpec, new String[0]), "*.{XML,xml}");){
                            for (Path path : stream) {
                                files.add(path.toFile());
                            }
                            break block48;
                        }
                        catch (IOException e) {
                            throw new IllegalStateException(String.format("Unable to list files %s; %s", payloadFileSpec, e.getMessage()), e);
                        }
                    }
                    if (fileSpec.isFile()) {
                        files.add(fileSpec);
                    } else {
                        log.warn(String.format("'%s' is neither file nor directory.", fileSpec.getAbsoluteFile()));
                    }
                }
            }
        }
        return files;
    }

    private static void printErrorMessage(String message) {
        System.out.println();
        System.out.println("*** " + message);
        System.out.println();
    }

    static OptionParser getOptionParser() {
        OptionParser optionParser = new OptionParser();
        fileSpec = optionParser.accepts("f", "File(s) to be transmitted").withRequiredArg().ofType(String.class);
        docType = optionParser.accepts("d", "Document type").withRequiredArg();
        profileType = optionParser.accepts("p", "Profile type").withRequiredArg();
        sender = optionParser.accepts("s", "sender [e.g. 9908:976098897]").withRequiredArg();
        recipient = optionParser.accepts("r", "recipient [e.g. 9908:976098897]").withRequiredArg();
        evidencePath = optionParser.accepts("e", "Evidence storage dir").withRequiredArg().ofType(File.class);
        useRequestFactory = optionParser.accepts("factory", "Use TransmissionRequestFactory (no overrides!)").withOptionalArg().ofType(Boolean.class).defaultsTo(false, (Boolean[])new Boolean[0]);
        repeatCount = optionParser.accepts("repeat", "Number of repeats to use ").withRequiredArg().ofType(Integer.class).defaultsTo(1, (Integer[])new Integer[0]);
        probe = optionParser.accepts("probe", "Perform probing of endpoint.").withRequiredArg().ofType(Boolean.class).defaultsTo(false, (Boolean[])new Boolean[0]);
        destinationUrl = optionParser.accepts("u", "destination URL").requiredIf(probe, protocol).withRequiredArg();
        destinationCertificate = optionParser.accepts("cert", "Receiving AP's certificate (when overriding endpoint)").requiredIf(destinationUrl, new OptionSpec[0]).withRequiredArg().ofType(File.class);
        protocol = optionParser.accepts("protocol", "Protocol to be used").withRequiredArg().ofType(String.class).defaultsTo(TransportProfile.AS2_1_0.getIdentifier(), (String[])new String[0]);
        maxTransmissions = optionParser.accepts("m", "Max number of transmissions").withRequiredArg().ofType(Integer.class).defaultsTo(Integer.MAX_VALUE, (Integer[])new Integer[0]);
        tag = optionParser.accepts("tag", "User defined tag").withRequiredArg();
        sleep = optionParser.accepts("sleep", "Sleep standalone for x seconds after transmission.").withRequiredArg().ofType(Integer.class).defaultsTo(0, (Integer[])new Integer[0]);
        return optionParser;
    }

    private static String enterPassword() {
        System.out.print("Keystore password: ");
        String password = null;
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));){
            password = bufferedReader.readLine();
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            System.exit(1);
        }
        return password;
    }
}

