/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.as2.code;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import network.oxalis.api.lang.VerifierException;
import network.oxalis.as2.code.DispositionModifier;
import network.oxalis.as2.code.DispositionModifierExtension;
import network.oxalis.as2.code.DispositionType;

public class Disposition {
    private static final Pattern PATTERN = Pattern.compile("^(.*?); ([a-z]+)/([a-z]+): (.*)|(.*?); ([a-z]+)$");
    private static final String SENT_AUTOMATICALLY = "automatic-action/MDN-sent-automatically";
    public static final Disposition PROCESSED = new Disposition(DispositionType.PROCESSED, null, null);
    public static final Disposition UNSUPPORTED_FORMAT = new Disposition(DispositionType.FAILED, DispositionModifier.FAILURE, DispositionModifierExtension.UNEXPECTED_PROCESSING_ERROR);
    public static final Disposition UNSUPPORTED_MIC_ALGORITHMS = new Disposition(DispositionType.FAILED, DispositionModifier.FAILURE, DispositionModifierExtension.UNSUPPORTED_MIC_ALGORITHMS);
    public static final Disposition SENDER_EQUALS_RECEIVER = new Disposition(DispositionType.FAILED, DispositionModifier.FAILURE, DispositionModifierExtension.SENDER_EQUALS_RECEIVER);
    public static final Disposition DECRYPTION_FAILED = new Disposition(DispositionType.FAILED, DispositionModifier.ERROR, DispositionModifierExtension.DECRYPTION_FAILED);
    public static final Disposition AUTHENTICATION_FAILED = new Disposition(DispositionType.FAILED, DispositionModifier.ERROR, DispositionModifierExtension.AUTHENTICATION_FAILED);
    public static final Disposition INTEGRITY_CHECK_FAILED = new Disposition(DispositionType.FAILED, DispositionModifier.ERROR, DispositionModifierExtension.INTEGRITY_CHECK_FAILED);
    public static final Disposition PARTICIPANT_NOT_ACCEPTED = new Disposition(DispositionType.FAILED, DispositionModifier.ERROR, DispositionModifierExtension.PARTICIPANT_NOT_ACCEPTED);
    public static final Disposition DOCUMENT_TYPE_ID_NOT_ACCEPTED = new Disposition(DispositionType.FAILED, DispositionModifier.ERROR, DispositionModifierExtension.DOCUMENT_TYPE_ID_NOT_ACCEPTED);
    public static final Disposition PROCESS_ID_NOT_ACCEPTED = new Disposition(DispositionType.FAILED, DispositionModifier.ERROR, DispositionModifierExtension.PROCESS_ID_NOT_ACCEPTED);
    public static final Disposition UNEXPECTED_PROCESSING_ERROR = new Disposition(DispositionType.FAILED, DispositionModifier.ERROR, DispositionModifierExtension.UNEXPECTED_PROCESSING_ERROR);
    public static final Disposition DUPLICATE_DOCUMENT = new Disposition(DispositionType.PROCESSED, DispositionModifier.WARNING, DispositionModifierExtension.DUPLICATE_DOCUMENT);
    private static Map<VerifierException.Reason, Disposition> verifierMap = ImmutableMap.builder().put(VerifierException.Reason.DOCUMENT_TYPE, DOCUMENT_TYPE_ID_NOT_ACCEPTED).put(VerifierException.Reason.PROCESS, PROCESS_ID_NOT_ACCEPTED).put(VerifierException.Reason.PARTICIPANT, PARTICIPANT_NOT_ACCEPTED).build();
    private DispositionType type;
    private DispositionModifier modifier;
    private DispositionModifierExtension extension;

    public static Disposition parse(String str) {
        String cleaned = str.replaceAll("[ \r\n\t]+", " ");
        Matcher matcher = PATTERN.matcher(cleaned);
        if (matcher.matches()) {
            if (matcher.group(1) == null) {
                return new Disposition(DispositionType.of(matcher.group(6)), null, null);
            }
            return new Disposition(DispositionType.of(matcher.group(2)), DispositionModifier.of(matcher.group(3)), DispositionModifierExtension.of(matcher.group(4)));
        }
        throw new IllegalStateException(String.format("Unable to parseOld disposition '%s'.", str));
    }

    public static Disposition fromVerifierException(VerifierException e) {
        return verifierMap.get((Object)e.getReason());
    }

    private Disposition(DispositionType type, DispositionModifier modifier, DispositionModifierExtension extension) {
        this.type = type;
        this.modifier = modifier;
        this.extension = extension;
    }

    public DispositionType getType() {
        return this.type;
    }

    public DispositionModifier getModifier() {
        return this.modifier;
    }

    public DispositionModifierExtension getExtension() {
        return this.extension;
    }

    public String toString() {
        if (this.modifier == null) {
            return String.format("%s; %s", new Object[]{SENT_AUTOMATICALLY, this.type});
        }
        return String.format("%s; %s/%s: %s", new Object[]{SENT_AUTOMATICALLY, this.type, this.modifier, this.extension});
    }
}

