/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.commons.mode;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import io.opentracing.contrib.apache.http.client.Constants;
import io.opentracing.contrib.spanmanager.DefaultSpanManager;
import io.opentracing.contrib.spanmanager.SpanManager;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.inject.Named;
import net.klakegg.pkix.ocsp.api.OcspFetcher;
import net.klakegg.pkix.ocsp.api.OcspFetcherResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.BasicHttpContext;

@Singleton
public class OxalisOcspFetcher
implements OcspFetcher {
    @Inject
    private Provider<CloseableHttpClient> httpClientProvider;
    @Inject
    @Named(value="certificate")
    private RequestConfig requestConfig;

    @Override
    public OcspFetcherResponse fetch(URI uri, byte[] content) throws IOException {
        SpanManager.ManagedSpan span = DefaultSpanManager.getInstance().current();
        BasicHttpContext basicHttpContext = new BasicHttpContext();
        if (span.getSpan() != null) {
            basicHttpContext.setAttribute(Constants.PARENT_CONTEXT, span.getSpan().context());
        }
        HttpPost httpPost = new HttpPost(uri);
        httpPost.setHeader("Content-Type", "application/ocsp-request");
        httpPost.setHeader("Accept", "application/ocsp-response");
        httpPost.setEntity(new ByteArrayEntity(content));
        httpPost.setConfig(this.requestConfig);
        return new ApacheOcspFetcherResponse(this.httpClientProvider.get().execute((HttpUriRequest)httpPost, basicHttpContext));
    }

    private class ApacheOcspFetcherResponse
    implements OcspFetcherResponse {
        private CloseableHttpResponse response;

        public ApacheOcspFetcherResponse(CloseableHttpResponse response) {
            this.response = response;
        }

        @Override
        public int getStatus() {
            return this.response.getStatusLine().getStatusCode();
        }

        @Override
        public String getContentType() {
            return this.response.getFirstHeader("Content-Type").getValue();
        }

        @Override
        public InputStream getContent() throws IOException {
            return this.response.getEntity().getContent();
        }

        @Override
        public void close() throws IOException {
            this.response.close();
            this.response = null;
        }
    }
}

