/*
 * Decompiled with CFR 0.152.
 */
package brave.opentracing;

import brave.Tracer;
import brave.Tracing;
import brave.opentracing.BraveScope;
import brave.opentracing.BraveScopeManager;
import brave.opentracing.BraveSpan;
import brave.opentracing.BraveSpanBuilder;
import brave.opentracing.BraveSpanContext;
import brave.opentracing.OpenTracingVersion;
import brave.propagation.B3SingleFormat;
import brave.propagation.ExtraFieldPropagation;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.propagation.BinaryExtract;
import io.opentracing.propagation.BinaryInject;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMap;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public final class BraveTracer
implements io.opentracing.Tracer {
    final Tracing tracing;
    final Tracer delegate;
    final BraveScopeManager scopeManager;
    final Map<Format<?>, TraceContext.Injector<?>> formatToInjector = new LinkedHashMap();
    final Map<Format<?>, TraceContext.Extractor<?>> formatToExtractor = new LinkedHashMap();
    static final Propagation.Setter<TextMap, String> TEXT_MAP_SETTER = new Propagation.Setter<TextMap, String>(){

        public void put(TextMap carrier, String key, String value) {
            carrier.put(key, value);
        }

        public String toString() {
            return "TextMap::put";
        }
    };
    static final Propagation.Getter<Map<String, String>, String> LC_MAP_GETTER = new Propagation.Getter<Map<String, String>, String>(){

        public String get(Map<String, String> carrier, String key) {
            return carrier.get(key.toLowerCase(Locale.ROOT));
        }

        public String toString() {
            return "Map::getLowerCase";
        }
    };

    public static BraveTracer create(Tracing brave4) {
        return BraveTracer.newBuilder(brave4).build();
    }

    public static Builder newBuilder(Tracing brave4) {
        try {
            OpenTracingVersion.get();
        }
        catch (ExceptionInInitializerError e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw e;
        }
        return new Builder(brave4);
    }

    BraveTracer(Builder b) {
        this.tracing = b.tracing;
        this.delegate = b.tracing.tracer();
        this.scopeManager = OpenTracingVersion.get().scopeManager(b.tracing);
        for (Map.Entry<Format<TextMap>, Propagation<String>> entry : b.formatToPropagation.entrySet()) {
            this.formatToInjector.put(entry.getKey(), entry.getValue().injector(TEXT_MAP_SETTER));
            this.formatToExtractor.put(entry.getKey(), new TextMapExtractorAdaptor(entry.getValue()));
        }
        for (Propagation propagation : b.formatToPropagation.values()) {
            this.formatToInjector.put(Format.Builtin.TEXT_MAP_INJECT, propagation.injector(TEXT_MAP_SETTER));
            this.formatToExtractor.put(Format.Builtin.TEXT_MAP_EXTRACT, new TextMapExtractorAdaptor((Propagation<String>)propagation));
        }
        this.formatToInjector.put(Format.Builtin.BINARY, BinaryCodec.INSTANCE);
        this.formatToInjector.put(Format.Builtin.BINARY_INJECT, BinaryCodec.INSTANCE);
        this.formatToExtractor.put(Format.Builtin.BINARY, BinaryCodec.INSTANCE);
        this.formatToExtractor.put(Format.Builtin.BINARY_EXTRACT, BinaryCodec.INSTANCE);
    }

    public BraveScopeManager scopeManager() {
        return this.scopeManager;
    }

    public BraveSpan activeSpan() {
        return this.scopeManager.activeSpan();
    }

    public BraveScope activateSpan(Span span) {
        return this.scopeManager.activate(span);
    }

    public BraveSpanBuilder buildSpan(String operationName) {
        return OpenTracingVersion.get().spanBuilder(this, operationName);
    }

    public <C> void inject(SpanContext spanContext, Format<C> format, C carrier) {
        TraceContext.Injector<?> injector = this.formatToInjector.get(format);
        if (injector == null) {
            throw new UnsupportedOperationException(format + " not in " + this.formatToInjector.keySet());
        }
        TraceContext traceContext = ((BraveSpanContext)spanContext).unwrap();
        injector.inject(traceContext, carrier);
    }

    public <C> BraveSpanContext extract(Format<C> format, C carrier) {
        TraceContext.Extractor<?> extractor = this.formatToExtractor.get(format);
        if (extractor == null) {
            throw new UnsupportedOperationException(format + " not in " + this.formatToExtractor.keySet());
        }
        TraceContextOrSamplingFlags extractionResult = extractor.extract(carrier);
        return BraveSpanContext.create(extractionResult);
    }

    public void close() {
        this.tracing.close();
    }

    static Set<String> lowercaseSet(List<String> fields) {
        LinkedHashSet<String> lcSet = new LinkedHashSet<String>();
        for (String f : fields) {
            lcSet.add(f.toLowerCase(Locale.ROOT));
        }
        return lcSet;
    }

    static enum BinaryCodec implements TraceContext.Injector<BinaryInject>,
    TraceContext.Extractor<BinaryExtract>
    {
        INSTANCE;

        final Charset ascii = Charset.forName("US-ASCII");

        public TraceContextOrSamplingFlags extract(BinaryExtract binaryExtract) {
            try {
                return B3SingleFormat.parseB3SingleFormat((CharSequence)this.ascii.decode(binaryExtract.extractionBuffer()));
            }
            catch (RuntimeException e) {
                return TraceContextOrSamplingFlags.EMPTY;
            }
        }

        public void inject(TraceContext traceContext, BinaryInject binaryInject) {
            byte[] injected = B3SingleFormat.writeB3SingleFormatAsBytes((TraceContext)traceContext);
            binaryInject.injectionBuffer(injected.length).put(injected);
        }
    }

    static final class TextMapExtractorAdaptor
    implements TraceContext.Extractor<TextMap> {
        final Set<String> allPropagationKeys;
        final TraceContext.Extractor<Map<String, String>> delegate;

        TextMapExtractorAdaptor(Propagation<String> propagation) {
            this.allPropagationKeys = BraveTracer.lowercaseSet(propagation.keys());
            if (propagation instanceof ExtraFieldPropagation) {
                this.allPropagationKeys.addAll(((ExtraFieldPropagation)propagation).extraKeys());
            }
            this.delegate = propagation.extractor(LC_MAP_GETTER);
        }

        public TraceContextOrSamplingFlags extract(TextMap entries) {
            LinkedHashMap<String, String> cache = new LinkedHashMap<String, String>();
            for (Map.Entry next : entries) {
                String inputKey = ((String)next.getKey()).toLowerCase(Locale.ROOT);
                if (!this.allPropagationKeys.contains(inputKey)) continue;
                cache.put(inputKey, (String)next.getValue());
            }
            return this.delegate.extract(cache);
        }
    }

    public static final class Builder {
        Tracing tracing;
        Map<Format<TextMap>, Propagation<String>> formatToPropagation = new LinkedHashMap<Format<TextMap>, Propagation<String>>();

        Builder(Tracing tracing) {
            if (tracing == null) {
                throw new NullPointerException("brave tracing component == null");
            }
            this.tracing = tracing;
            this.formatToPropagation.put((Format<TextMap>)Format.Builtin.HTTP_HEADERS, (Propagation<String>)tracing.propagation());
            this.formatToPropagation.put((Format<TextMap>)Format.Builtin.TEXT_MAP, (Propagation<String>)tracing.propagation());
        }

        public Builder textMapPropagation(Format<TextMap> format, Propagation<String> propagation) {
            if (format == null) {
                throw new NullPointerException("format == null");
            }
            if (propagation == null) {
                throw new NullPointerException("propagation == null");
            }
            this.formatToPropagation.put(format, propagation);
            return this;
        }

        public BraveTracer build() {
            return new BraveTracer(this);
        }
    }
}

