/*
 * Decompiled with CFR 0.152.
 */
package brave.internal.handler;

import brave.ErrorParser;
import brave.handler.FinishedSpanHandler;
import brave.handler.MutableSpan;
import brave.internal.handler.MutableSpanConverter;
import brave.propagation.TraceContext;
import zipkin2.Span;
import zipkin2.reporter.Reporter;

public final class ZipkinFinishedSpanHandler
extends FinishedSpanHandler {
    final Reporter<Span> spanReporter;
    final MutableSpanConverter converter;

    public ZipkinFinishedSpanHandler(Reporter<Span> spanReporter, ErrorParser errorParser, String serviceName, String ip, int port) {
        this.spanReporter = spanReporter;
        this.converter = new MutableSpanConverter(errorParser, serviceName, ip, port);
    }

    @Override
    public boolean handle(TraceContext context, MutableSpan span) {
        if (!Boolean.TRUE.equals(context.sampled())) {
            return true;
        }
        Span.Builder builderWithContextData = Span.newBuilder().traceId(context.traceIdString()).parentId(context.parentIdString()).id(context.spanIdString());
        if (context.debug()) {
            builderWithContextData.debug(true);
        }
        this.converter.convert(span, builderWithContextData);
        this.spanReporter.report((Object)builderWithContextData.build());
        return true;
    }

    public String toString() {
        return this.spanReporter.toString();
    }
}

