/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.commons.header;

import com.google.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import network.oxalis.api.header.HeaderParser;
import network.oxalis.api.lang.OxalisContentException;
import network.oxalis.api.util.Type;
import network.oxalis.vefa.peppol.common.model.Header;
import network.oxalis.vefa.peppol.sbdh.SbdReader;
import network.oxalis.vefa.peppol.sbdh.lang.SbdhException;

@Type(value={"sbdh"})
@Singleton
public class SbdhHeaderParser
implements HeaderParser {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Header parse(InputStream inputStream) throws OxalisContentException {
        try (SbdReader sbdReader = SbdReader.newInstance(inputStream);){
            Header header = sbdReader.getHeader();
            return header;
        }
        catch (IOException | SbdhException e) {
            throw new OxalisContentException(e.getMessage(), e);
        }
    }
}

