/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.evidence.rem;

import java.io.OutputStream;
import java.math.BigInteger;
import javax.xml.bind.Marshaller;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamResult;
import network.oxalis.vefa.peppol.common.model.Receipt;
import network.oxalis.vefa.peppol.common.util.ExceptionUtil;
import network.oxalis.vefa.peppol.evidence.jaxb.receipt.OriginalReceiptType;
import network.oxalis.vefa.peppol.evidence.jaxb.receipt.PeppolRemExtension;
import network.oxalis.vefa.peppol.evidence.jaxb.rem.EntityDetailsListType;
import network.oxalis.vefa.peppol.evidence.jaxb.rem.EntityDetailsType;
import network.oxalis.vefa.peppol.evidence.jaxb.rem.EntityNameType;
import network.oxalis.vefa.peppol.evidence.jaxb.rem.EventReasonsType;
import network.oxalis.vefa.peppol.evidence.jaxb.rem.EvidenceIssuerPolicyIDType;
import network.oxalis.vefa.peppol.evidence.jaxb.rem.ExtensionType;
import network.oxalis.vefa.peppol.evidence.jaxb.rem.ExtensionsListType;
import network.oxalis.vefa.peppol.evidence.jaxb.rem.MessageDetailsType;
import network.oxalis.vefa.peppol.evidence.jaxb.rem.NamePostalAddressType;
import network.oxalis.vefa.peppol.evidence.jaxb.rem.NamesPostalAddressListType;
import network.oxalis.vefa.peppol.evidence.jaxb.rem.REMEvidenceType;
import network.oxalis.vefa.peppol.evidence.jaxb.xmldsig.DigestMethodType;
import network.oxalis.vefa.peppol.evidence.lang.RemEvidenceException;
import network.oxalis.vefa.peppol.evidence.rem.Evidence;
import network.oxalis.vefa.peppol.evidence.rem.RemHelper;
import org.w3c.dom.Node;

public class EvidenceWriter {
    private Evidence evidence;
    private REMEvidenceType remEvidence = new REMEvidenceType();

    public static void write(OutputStream outputStream, Evidence evidence) throws RemEvidenceException {
        EvidenceWriter evidenceWriter = new EvidenceWriter(evidence);
        evidenceWriter.prepare();
        evidenceWriter.write(new StreamResult(outputStream));
    }

    public static void write(Node node, Evidence evidence) throws RemEvidenceException {
        EvidenceWriter evidenceWriter = new EvidenceWriter(evidence);
        evidenceWriter.prepare();
        evidenceWriter.write(new DOMResult(node));
    }

    private EvidenceWriter(Evidence evidence) {
        this.evidence = evidence;
    }

    private void prepare() throws RemEvidenceException {
        this.remEvidence.setVersion("2");
        this.remEvidence.setEventCode(this.evidence.getEventCode().getValue());
        if (this.evidence.getEventReason() != null) {
            this.remEvidence.setEventReasons(new EventReasonsType());
            this.remEvidence.getEventReasons().getEventReason().add(RemHelper.createEventReasonType(this.evidence.getEventReason()));
        }
        NamePostalAddressType namePostalAddressType = new NamePostalAddressType();
        namePostalAddressType.setEntityName(new EntityNameType());
        namePostalAddressType.getEntityName().getName().add(this.evidence.getIssuer());
        this.remEvidence.setEvidenceIssuerDetails(new EntityDetailsType());
        this.remEvidence.getEvidenceIssuerDetails().setNamesPostalAddresses(new NamesPostalAddressListType());
        this.remEvidence.getEvidenceIssuerDetails().getNamesPostalAddresses().getNamePostalAddress().add(namePostalAddressType);
        this.remEvidence.setEvidenceIdentifier(this.evidence.getEvidenceIdentifier().getIdentifier());
        if (this.evidence.getIssuerPolicy() != null) {
            this.remEvidence.setEvidenceIssuerPolicyID(new EvidenceIssuerPolicyIDType());
            this.remEvidence.getEvidenceIssuerPolicyID().getPolicyID().add(this.evidence.getIssuerPolicy());
        }
        this.remEvidence.setEventTime(RemHelper.toXmlGregorianCalendar(this.evidence.getTimestamp()));
        this.remEvidence.setSenderDetails(new EntityDetailsType());
        this.remEvidence.getSenderDetails().getAttributedElectronicAddressOrElectronicAddress().add(RemHelper.createElectronicAddressType(this.evidence.getSender()));
        this.remEvidence.setRecipientsDetails(new EntityDetailsListType());
        this.remEvidence.getRecipientsDetails().getEntityDetails().add(new EntityDetailsType());
        this.remEvidence.getRecipientsDetails().getEntityDetails().get(0).getAttributedElectronicAddressOrElectronicAddress().add(RemHelper.createElectronicAddressType(this.evidence.getReceiver()));
        this.remEvidence.setEvidenceRefersToRecipient(BigInteger.valueOf(1L));
        MessageDetailsType messageDetailsType = new MessageDetailsType();
        messageDetailsType.setMessageSubject(this.evidence.getDocumentTypeIdentifier().getIdentifier());
        if (this.evidence.getDocumentIdentifier() != null) {
            messageDetailsType.setUAMessageIdentifier(this.evidence.getDocumentIdentifier().getIdentifier());
        }
        messageDetailsType.setMessageIdentifierByREMMD(this.evidence.getMessageIdentifier().getIdentifier());
        DigestMethodType digestMethodType = new DigestMethodType();
        digestMethodType.setAlgorithm(this.evidence.getDigest().getMethod().getUri());
        messageDetailsType.setDigestMethod(digestMethodType);
        messageDetailsType.setDigestValue(this.evidence.getDigest().getValue());
        messageDetailsType.setIsNotification(false);
        this.remEvidence.setSenderMessageDetails(messageDetailsType);
        ExtensionsListType extensionsListType = new ExtensionsListType();
        if (this.evidence.hasPeppolExtensionValues()) {
            PeppolRemExtension peppolRemExtension = new PeppolRemExtension();
            peppolRemExtension.setTransmissionProtocol(this.evidence.getTransportProtocol().getIdentifier());
            peppolRemExtension.setTransmissionRole(this.evidence.getTransmissionRole());
            for (Receipt receipt : this.evidence.getOriginalReceipts()) {
                peppolRemExtension.getOriginalReceipt().add(this.convert(receipt));
            }
            ExtensionType extensionType = new ExtensionType();
            extensionType.getContent().add(peppolRemExtension);
            extensionsListType.getExtension().add(extensionType);
        }
        if (extensionsListType.getExtension().size() > 0) {
            this.remEvidence.setExtensions(extensionsListType);
        }
    }

    private OriginalReceiptType convert(Receipt receipt) {
        OriginalReceiptType originalReceiptType = new OriginalReceiptType();
        originalReceiptType.setType(receipt.getType());
        originalReceiptType.setValue(receipt.getValue());
        return originalReceiptType;
    }

    private void write(Result result) throws RemEvidenceException {
        ExceptionUtil.perform(RemEvidenceException.class, () -> {
            Marshaller marshaller = RemHelper.getMarshaller();
            marshaller.marshal(this.evidence.getType().toJAXBElement(this.remEvidence), result);
        });
    }
}

