/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.apache.http.client;

import io.opentracing.Tracer;
import io.opentracing.contrib.apache.http.client.ApacheClientSpanDecorator;
import io.opentracing.contrib.apache.http.client.TracingClientExec;
import io.opentracing.util.GlobalTracer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.execchain.ClientExecChain;

public class TracingHttpClientBuilder
extends HttpClientBuilder {
    private final RedirectStrategy redirectStrategy;
    private final boolean redirectHandlingDisabled;
    private Tracer tracer;
    private List<ApacheClientSpanDecorator> spanDecorators;

    public TracingHttpClientBuilder() {
        this((RedirectStrategy)DefaultRedirectStrategy.INSTANCE, false, GlobalTracer.get(), Collections.singletonList(new ApacheClientSpanDecorator.StandardTags()));
    }

    public TracingHttpClientBuilder(RedirectStrategy redirectStrategy, boolean redirectHandlingDisabled) {
        this(redirectStrategy, redirectHandlingDisabled, GlobalTracer.get(), Collections.singletonList(new ApacheClientSpanDecorator.StandardTags()));
    }

    public TracingHttpClientBuilder(RedirectStrategy redirectStrategy, boolean redirectHandlingDisabled, Tracer tracer, List<ApacheClientSpanDecorator> spanDecorators) {
        this.redirectStrategy = redirectStrategy;
        this.redirectHandlingDisabled = redirectHandlingDisabled;
        this.tracer = tracer;
        this.spanDecorators = new ArrayList<ApacheClientSpanDecorator>(spanDecorators);
        super.setRedirectStrategy(redirectStrategy);
        if (redirectHandlingDisabled) {
            super.disableRedirectHandling();
        }
    }

    public static TracingHttpClientBuilder create() {
        return new TracingHttpClientBuilder();
    }

    public TracingHttpClientBuilder withTracer(Tracer tracer) {
        this.tracer = tracer;
        return this;
    }

    public TracingHttpClientBuilder withSpanDecorators(List<ApacheClientSpanDecorator> decorators) {
        this.spanDecorators = new ArrayList<ApacheClientSpanDecorator>(decorators);
        return this;
    }

    protected ClientExecChain decorateProtocolExec(ClientExecChain requestExecutor) {
        return new TracingClientExec(requestExecutor, this.redirectStrategy, this.redirectHandlingDisabled, this.tracer, this.spanDecorators);
    }
}

