/*
 * Decompiled with CFR 0.152.
 */
package no.difi.certvalidator.structure;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import no.difi.certvalidator.api.CertificateValidationException;
import no.difi.certvalidator.api.FailedValidationException;
import no.difi.certvalidator.api.Report;
import no.difi.certvalidator.api.ValidatorRule;
import no.difi.certvalidator.structure.AbstractJunction;

public class XorJunction
extends AbstractJunction {
    public XorJunction(ValidatorRule ... validatorRules) {
        super(validatorRules);
    }

    public XorJunction(List<ValidatorRule> validatorRules) {
        super(validatorRules);
    }

    @Override
    public Report validate(X509Certificate certificate, Report report) throws CertificateValidationException {
        ArrayList<CertificateValidationException> exceptions = new ArrayList<CertificateValidationException>();
        for (ValidatorRule validatorRule : this.validatorRules) {
            try {
                report = validatorRule.validate(certificate, report.copy());
            }
            catch (CertificateValidationException certificateValidationException) {
                exceptions.add(certificateValidationException);
            }
        }
        if (exceptions.size() != this.validatorRules.size() - 1) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(String.format("Xor-junction failed with results (%s of %s):", exceptions.size(), this.validatorRules.size()));
            for (Exception exception : exceptions) {
                stringBuilder.append("\n* ").append(exception.getMessage());
            }
            throw new FailedValidationException(stringBuilder.toString());
        }
        return report;
    }
}

