/*
 * Decompiled with CFR 0.152.
 */
package no.difi.certvalidator.parser;

import java.security.cert.X509Certificate;
import java.util.Map;
import no.difi.certvalidator.Validator;
import no.difi.certvalidator.api.CertificateValidationException;
import no.difi.certvalidator.api.Order;
import no.difi.certvalidator.api.ValidatorRecipeParser;
import no.difi.certvalidator.jaxb.CertificateBucketType;
import no.difi.certvalidator.jaxb.CertificateReferenceType;
import no.difi.certvalidator.jaxb.CertificateStartsWithType;
import no.difi.certvalidator.jaxb.CertificateType;
import no.difi.certvalidator.jaxb.ValidatorRecipe;
import no.difi.certvalidator.lang.ValidatorParsingException;
import no.difi.certvalidator.util.KeyStoreCertificateBucket;
import no.difi.certvalidator.util.SimpleCertificateBucket;

@Order(value=200)
public class ValidatorBucketsLoader
implements ValidatorRecipeParser {
    @Override
    public void parse(ValidatorRecipe recipe, Map<String, Object> objectStorage) throws ValidatorParsingException {
        try {
            for (CertificateBucketType certificateBucketType : recipe.getCertificateBucket()) {
                SimpleCertificateBucket certificateBucket = new SimpleCertificateBucket(new X509Certificate[0]);
                for (Object o : certificateBucketType.getCertificateOrCertificateReferenceOrCertificateStartsWith()) {
                    Object c;
                    if (o instanceof CertificateType) {
                        certificateBucket.add(Validator.getCertificate(((CertificateType)o).getValue()));
                        continue;
                    }
                    if (o instanceof CertificateReferenceType) {
                        c = (CertificateReferenceType)o;
                        for (X509Certificate certificate : ValidatorBucketsLoader.getKeyStore(((CertificateReferenceType)c).getKeyStore(), objectStorage).toSimple(((CertificateReferenceType)c).getValue())) {
                            certificateBucket.add(certificate);
                        }
                        continue;
                    }
                    if (!(o instanceof CertificateStartsWithType)) continue;
                    c = (CertificateStartsWithType)o;
                    for (X509Certificate certificate : ValidatorBucketsLoader.getKeyStore(((CertificateStartsWithType)c).getKeyStore(), objectStorage).startsWith(((CertificateStartsWithType)c).getValue())) {
                        certificateBucket.add(certificate);
                    }
                }
                objectStorage.put(String.format("#bucket::%s", certificateBucketType.getName()), certificateBucket);
            }
        }
        catch (CertificateValidationException e) {
            throw new ValidatorParsingException(e.getMessage(), e);
        }
    }

    private static KeyStoreCertificateBucket getKeyStore(String name, Map<String, Object> objectStorage) {
        return (KeyStoreCertificateBucket)objectStorage.get(String.format("#keyStore::%s", name == null ? "default" : name));
    }
}

