/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.impl;

import java.time.Duration;
import org.apache.commons.pool2.impl.PoolImplUtils;

public class EvictionConfig {
    private static final Duration MAX_MILLIS_DURATION = Duration.ofMillis(Long.MAX_VALUE);
    private final Duration idleEvictTime;
    private final Duration idleSoftEvictTime;
    private final int minIdle;

    public EvictionConfig(Duration poolIdleEvictTime, Duration poolIdleSoftEvictTime, int minIdle) {
        this.idleEvictTime = PoolImplUtils.isPositive(poolIdleEvictTime) ? poolIdleEvictTime : MAX_MILLIS_DURATION;
        this.idleSoftEvictTime = PoolImplUtils.isPositive(poolIdleSoftEvictTime) ? poolIdleSoftEvictTime : MAX_MILLIS_DURATION;
        this.minIdle = minIdle;
    }

    @Deprecated
    public EvictionConfig(long poolIdleEvictTime, long poolIdleSoftEvictTime, int minIdle) {
        this(Duration.ofMillis(poolIdleEvictTime), Duration.ofMillis(poolIdleSoftEvictTime), minIdle);
    }

    public long getIdleEvictTime() {
        return this.idleEvictTime.toMillis();
    }

    public Duration getIdleEvictTimeDuration() {
        return this.idleEvictTime;
    }

    public long getIdleSoftEvictTime() {
        return this.idleSoftEvictTime.toMillis();
    }

    public Duration getIdleSoftEvictTimeDuration() {
        return this.idleSoftEvictTime;
    }

    public int getMinIdle() {
        return this.minIdle;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("EvictionConfig [idleEvictTime=");
        builder.append(this.idleEvictTime);
        builder.append(", idleSoftEvictTime=");
        builder.append(this.idleSoftEvictTime);
        builder.append(", minIdle=");
        builder.append(this.minIdle);
        builder.append("]");
        return builder.toString();
    }
}

