/*
 * Decompiled with CFR 0.152.
 */
package brave.internal;

import brave.internal.InternalPropagation;
import brave.internal.Lists;
import brave.propagation.TraceContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class ExtraFactory<E> {
    public abstract Class<E> type();

    protected abstract E create();

    protected abstract E create(E var1);

    protected abstract E createExtraAndClaim(long var1, long var3);

    protected abstract E createExtraAndClaim(E var1, long var2, long var4);

    protected abstract boolean tryToClaim(E var1, long var2, long var4);

    protected abstract void consolidate(E var1, E var2);

    public final TraceContext decorate(TraceContext context) {
        long traceId = context.traceId();
        long spanId = context.spanId();
        Class<E> type = this.type();
        List<Object> extra = context.extra();
        int extraSize = extra.size();
        if (extraSize == 0) {
            extra = Collections.singletonList(this.createExtraAndClaim(traceId, spanId));
            return this.contextWithExtra(context, extra);
        }
        Object first = extra.get(0);
        Object consolidated = null;
        if (type.isInstance(first)) {
            Object existing = first;
            consolidated = this.tryToClaim(existing, traceId, spanId) ? existing : this.createExtraAndClaim(existing, traceId, spanId);
        }
        if (extraSize == 1) {
            if (consolidated != null) {
                if (consolidated == first) {
                    return context;
                }
                return this.contextWithExtra(context, Collections.singletonList(consolidated));
            }
            extra = new ArrayList<Object>(2);
            extra.add(first);
            extra.add(this.createExtraAndClaim(traceId, spanId));
            return this.contextWithExtra(context, Collections.unmodifiableList(extra));
        }
        for (int i = 1; i < extraSize; ++i) {
            Object next = extra.get(i);
            if (!type.isInstance(next)) continue;
            Object existing = next;
            if (consolidated == null) {
                if (this.tryToClaim(existing, traceId, spanId)) {
                    consolidated = existing;
                    continue;
                }
                consolidated = this.createExtraAndClaim(existing, traceId, spanId);
                extra = Lists.ensureMutable(extra);
                extra.set(i, consolidated);
                continue;
            }
            this.consolidate(existing, consolidated);
            extra = Lists.ensureMutable(extra);
            extra.remove(i);
            --extraSize;
            --i;
        }
        if (consolidated == null) {
            consolidated = this.createExtraAndClaim(traceId, spanId);
            extra = Lists.ensureMutable(extra);
            extra.add(consolidated);
        }
        if (extra == context.extra()) {
            return context;
        }
        return this.contextWithExtra(context, Collections.unmodifiableList(extra));
    }

    protected TraceContext contextWithExtra(TraceContext context, List<Object> immutableExtra) {
        return InternalPropagation.instance.withExtra(context, immutableExtra);
    }
}

