/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.as2.util;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.MimeType;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import network.oxalis.api.lang.OxalisSecurityException;
import network.oxalis.api.lang.OxalisTransmissionException;
import network.oxalis.as2.util.MimeMessageHelper;
import network.oxalis.as2.util.SMimeBC;
import network.oxalis.as2.util.SMimeDigestMethod;
import network.oxalis.commons.bouncycastle.BCHelper;
import network.oxalis.vefa.peppol.common.model.Digest;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoGeneratorBuilder;
import org.bouncycastle.mail.smime.SMIMEException;
import org.bouncycastle.mail.smime.SMIMESignedGenerator;
import org.bouncycastle.operator.OperatorCreationException;

@Singleton
public class SMimeMessageFactory {
    private final PrivateKey privateKey;
    private final X509Certificate ourCertificate;
    private static final Session session = Session.getDefaultInstance(System.getProperties(), null);

    @Inject
    public SMimeMessageFactory(PrivateKey privateKey, X509Certificate ourCertificate) {
        this.privateKey = privateKey;
        this.ourCertificate = ourCertificate;
    }

    public MimeMessage createSignedMimeMessage(String msg, MimeType mimeType, SMimeDigestMethod digestMethod) throws OxalisTransmissionException {
        return this.createSignedMimeMessage(new ByteArrayInputStream(msg.getBytes()), mimeType, digestMethod);
    }

    public MimeMessage createSignedMimeMessage(InputStream inputStream, MimeType mimeType, SMimeDigestMethod digestMethod) throws OxalisTransmissionException {
        MimeBodyPart mimeBodyPart = MimeMessageHelper.createMimeBodyPart(inputStream, mimeType.toString());
        return this.createSignedMimeMessage(mimeBodyPart, digestMethod);
    }

    public MimeMessage createSignedMimeMessage(MimeBodyPart mimeBodyPart, SMimeDigestMethod digestMethod) throws OxalisTransmissionException {
        MimeMultipart mimeMultipart;
        JcaCertStore certs;
        ASN1EncodableVector signedAttrs = new ASN1EncodableVector();
        SMIMESignedGenerator smimeSignedGenerator = new SMIMESignedGenerator("binary");
        try {
            smimeSignedGenerator.addSignerInfoGenerator(new JcaSimpleSignerInfoGeneratorBuilder().setProvider("BC").setSignedAttributeGenerator(new AttributeTable(signedAttrs)).build(digestMethod.getMethod(), this.privateKey, this.ourCertificate));
        }
        catch (OperatorCreationException e) {
            throw new OxalisTransmissionException("Unable to add Signer information. " + e.getMessage(), (Throwable)e);
        }
        catch (CertificateEncodingException e) {
            throw new OxalisTransmissionException(String.format("Certificate encoding problems while adding signer information. %s", e.getMessage()), (Throwable)e);
        }
        try {
            certs = new JcaCertStore(Collections.singleton(this.ourCertificate));
        }
        catch (CertificateEncodingException e) {
            throw new OxalisTransmissionException("Unable to create JcaCertStore with our certificate. " + e.getMessage(), (Throwable)e);
        }
        smimeSignedGenerator.addCertificates(certs);
        try {
            mimeMultipart = smimeSignedGenerator.generate(mimeBodyPart);
        }
        catch (SMIMEException e) {
            throw new OxalisTransmissionException("Unable to generate signed mime multipart." + e.getMessage(), (Throwable)e);
        }
        Properties props = System.getProperties();
        Session session = Session.getDefaultInstance(props, null);
        MimeMessage mimeMessage = new MimeMessage(session);
        try {
            mimeMessage.setContent(mimeMultipart, mimeMultipart.getContentType());
        }
        catch (MessagingException e) {
            throw new OxalisTransmissionException("Unable to  set Content type of MimeMessage. " + e.getMessage(), (Throwable)e);
        }
        try {
            mimeMessage.saveChanges();
        }
        catch (MessagingException e) {
            throw new OxalisTransmissionException("Unable to save changes to Mime message. " + e.getMessage(), (Throwable)e);
        }
        return mimeMessage;
    }

    public MimeMessage createSignedMimeMessageNew(MimeBodyPart mimeBodyPart, Digest digest, SMimeDigestMethod digestMethod) throws OxalisTransmissionException {
        try {
            MimeMultipart mimeMultipart = new MimeMultipart();
            mimeMultipart.setSubType("signed");
            mimeMultipart.addBodyPart(mimeBodyPart);
            MimeBodyPart signaturePart = new MimeBodyPart();
            ByteArrayDataSource dataSource = new ByteArrayDataSource(SMimeBC.createSignature(digest.getValue(), digestMethod, this.privateKey, this.ourCertificate), "application/pkcs7-signature");
            signaturePart.setDataHandler(new DataHandler((DataSource)dataSource));
            signaturePart.setHeader("Content-Type", "application/pkcs7-signature; name=smime.p7s; smime-type=signed-data");
            signaturePart.setHeader("Content-Transfer-Encoding", "base64");
            signaturePart.setHeader("Content-Disposition", "attachment; filename=\"smime.p7s\"");
            signaturePart.setHeader("Content-Description", "S/MIME Cryptographic Signature");
            mimeMultipart.addBodyPart(signaturePart);
            MimeMessage mimeMessage = new MimeMessage(session);
            mimeMessage.setContent(mimeMultipart, mimeMultipart.getContentType());
            mimeMessage.saveChanges();
            return mimeMessage;
        }
        catch (MessagingException | OxalisSecurityException e) {
            throw new OxalisTransmissionException(e.getMessage(), (Throwable)e);
        }
    }

    static {
        BCHelper.registerProvider();
    }
}

