/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.lookup.reader;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import network.oxalis.vefa.peppol.common.api.PotentiallySigned;
import network.oxalis.vefa.peppol.common.lang.PeppolRuntimeException;
import network.oxalis.vefa.peppol.common.model.DocumentTypeIdentifier;
import network.oxalis.vefa.peppol.common.model.Endpoint;
import network.oxalis.vefa.peppol.common.model.ParticipantIdentifier;
import network.oxalis.vefa.peppol.common.model.ProcessIdentifier;
import network.oxalis.vefa.peppol.common.model.ProcessMetadata;
import network.oxalis.vefa.peppol.common.model.Redirect;
import network.oxalis.vefa.peppol.common.model.Scheme;
import network.oxalis.vefa.peppol.common.model.ServiceInformation;
import network.oxalis.vefa.peppol.common.model.ServiceMetadata;
import network.oxalis.vefa.peppol.common.model.ServiceReference;
import network.oxalis.vefa.peppol.common.model.Signed;
import network.oxalis.vefa.peppol.common.model.TransportProfile;
import network.oxalis.vefa.peppol.common.util.ExceptionUtil;
import network.oxalis.vefa.peppol.lookup.api.FetcherResponse;
import network.oxalis.vefa.peppol.lookup.api.LookupException;
import network.oxalis.vefa.peppol.lookup.api.MetadataReader;
import network.oxalis.vefa.peppol.lookup.api.Namespace;
import network.oxalis.vefa.peppol.lookup.model.DocumentTypeIdentifierWithUri;
import network.oxalis.vefa.peppol.lookup.util.XmlUtils;
import network.oxalis.vefa.peppol.security.lang.PeppolSecurityException;
import network.oxalis.vefa.peppol.security.xmldsig.DomUtils;
import network.oxalis.vefa.peppol.security.xmldsig.XmldsigVerifier;
import no.difi.commons.bdx.jaxb.smp._2014._07.EndpointType;
import no.difi.commons.bdx.jaxb.smp._2014._07.ProcessType;
import no.difi.commons.bdx.jaxb.smp._2014._07.RedirectType;
import no.difi.commons.bdx.jaxb.smp._2014._07.ServiceGroupType;
import no.difi.commons.bdx.jaxb.smp._2014._07.ServiceInformationType;
import no.difi.commons.bdx.jaxb.smp._2014._07.ServiceMetadataReferenceType;
import no.difi.commons.bdx.jaxb.smp._2014._07.ServiceMetadataType;
import no.difi.commons.bdx.jaxb.smp._2014._07.SignedServiceMetadataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@Namespace(value="http://docs.oasis-open.org/bdxr/ns/SMP/2014/07")
public class Bdxr201407Reader
implements MetadataReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(Bdxr201407Reader.class);
    private static JAXBContext jaxbContext;
    private static CertificateFactory certificateFactory;

    @Override
    public List<ServiceReference> parseServiceGroup(FetcherResponse fetcherResponse) throws LookupException {
        try {
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            ServiceGroupType serviceGroup = (ServiceGroupType)unmarshaller.unmarshal(XmlUtils.streamReader(fetcherResponse.getInputStream()), ServiceGroupType.class).getValue();
            ArrayList<ServiceReference> serviceReferences = new ArrayList<ServiceReference>();
            for (ServiceMetadataReferenceType reference : serviceGroup.getServiceMetadataReferenceCollection().getServiceMetadataReference()) {
                String hrefDocumentTypeIdentifier = URLDecoder.decode(reference.getHref(), "UTF-8").split("/services/")[1];
                String[] parts = hrefDocumentTypeIdentifier.split("::", 2);
                try {
                    serviceReferences.add(ServiceReference.of((DocumentTypeIdentifier)DocumentTypeIdentifierWithUri.of(parts[1], Scheme.of(parts[0]), URI.create(reference.getHref())), new ProcessIdentifier[0]));
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    LOGGER.warn("Unable to parse '{}'.", (Object)hrefDocumentTypeIdentifier);
                }
            }
            return serviceReferences;
        }
        catch (UnsupportedEncodingException | JAXBException | XMLStreamException e) {
            throw new LookupException(e.getMessage(), e);
        }
    }

    @Override
    public PotentiallySigned<ServiceMetadata> parseServiceMetadata(FetcherResponse fetcherResponse) throws LookupException, PeppolSecurityException {
        try {
            Document doc = DomUtils.parse(fetcherResponse.getInputStream());
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            Object o = ((JAXBElement)unmarshaller.unmarshal((Source)new DOMSource(doc))).getValue();
            X509Certificate signer = null;
            if (o instanceof SignedServiceMetadataType) {
                signer = XmldsigVerifier.verify(doc);
                o = ((SignedServiceMetadataType)o).getServiceMetadata();
            }
            ServiceMetadataType serviceMetadataType = (ServiceMetadataType)o;
            ServiceMetadata serviceMetadata = this.getServiceMetadata(serviceMetadataType);
            return Signed.of(serviceMetadata, signer);
        }
        catch (IOException | CertificateException | JAXBException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private ServiceMetadata getServiceMetadata(ServiceMetadataType serviceMetadataType) throws CertificateException, LookupException {
        ServiceInformationType serviceInformation = serviceMetadataType.getServiceInformation();
        if (serviceInformation != null) {
            return this.getServiceMetadata(serviceInformation);
        }
        RedirectType redirect = serviceMetadataType.getRedirect();
        if (redirect != null) {
            return ServiceMetadata.of(Redirect.of(redirect.getCertificateUID(), redirect.getHref()));
        }
        throw new LookupException("Expected one of ServiceInformationType or RedirectType");
    }

    private ServiceMetadata getServiceMetadata(ServiceInformationType serviceInformation) throws CertificateException {
        ArrayList processMetadatas = new ArrayList();
        for (ProcessType processType : serviceInformation.getProcessList().getProcess()) {
            ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
            for (EndpointType endpointType : processType.getServiceEndpointList().getEndpoint()) {
                endpoints.add(Endpoint.of(TransportProfile.of(endpointType.getTransportProfile()), URI.create(endpointType.getEndpointURI()), this.certificateInstance(endpointType.getCertificate())));
            }
            processMetadatas.add(ProcessMetadata.of(ProcessIdentifier.of(processType.getProcessIdentifier().getValue(), Scheme.of(processType.getProcessIdentifier().getScheme())), endpoints));
        }
        ServiceMetadata serviceMetadata = ServiceMetadata.of(ServiceInformation.of(ParticipantIdentifier.of(serviceInformation.getParticipantIdentifier().getValue(), Scheme.of(serviceInformation.getParticipantIdentifier().getScheme())), DocumentTypeIdentifier.of(serviceInformation.getDocumentIdentifier().getValue(), Scheme.of(serviceInformation.getDocumentIdentifier().getScheme())), processMetadatas));
        return serviceMetadata;
    }

    private X509Certificate certificateInstance(byte[] content) throws CertificateException {
        return (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(content));
    }

    static {
        ExceptionUtil.perform(PeppolRuntimeException.class, () -> {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ServiceGroupType.class, SignedServiceMetadataType.class, ServiceMetadataType.class});
            certificateFactory = CertificateFactory.getInstance("X.509");
        });
    }
}

