/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.xbill.DNS.Message;
import org.xbill.DNS.Options;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.ResolverConfig;
import org.xbill.DNS.ResolverListener;
import org.xbill.DNS.SimpleResolver;
import org.xbill.DNS.TSIG;

public class ExtendedResolver
implements Resolver {
    private static final int quantum = 5;
    private List resolvers;
    private boolean loadBalance = false;
    private int lbStart = 0;
    private int retries = 3;

    private void init() {
        this.resolvers = new ArrayList();
    }

    public ExtendedResolver() throws UnknownHostException {
        this.init();
        String[] servers = ResolverConfig.getCurrentConfig().servers();
        if (servers != null) {
            for (int i = 0; i < servers.length; ++i) {
                SimpleResolver r = new SimpleResolver(servers[i]);
                r.setTimeout(5);
                this.resolvers.add(r);
            }
        } else {
            this.resolvers.add(new SimpleResolver());
        }
    }

    public ExtendedResolver(String[] servers) throws UnknownHostException {
        this.init();
        for (int i = 0; i < servers.length; ++i) {
            SimpleResolver r = new SimpleResolver(servers[i]);
            r.setTimeout(5);
            this.resolvers.add(r);
        }
    }

    public ExtendedResolver(Resolver[] res) throws UnknownHostException {
        this.init();
        for (int i = 0; i < res.length; ++i) {
            this.resolvers.add(res[i]);
        }
    }

    public void setPort(int port) {
        for (int i = 0; i < this.resolvers.size(); ++i) {
            ((Resolver)this.resolvers.get(i)).setPort(port);
        }
    }

    public void setTCP(boolean flag) {
        for (int i = 0; i < this.resolvers.size(); ++i) {
            ((Resolver)this.resolvers.get(i)).setTCP(flag);
        }
    }

    public void setIgnoreTruncation(boolean flag) {
        for (int i = 0; i < this.resolvers.size(); ++i) {
            ((Resolver)this.resolvers.get(i)).setIgnoreTruncation(flag);
        }
    }

    public void setEDNS(int level) {
        for (int i = 0; i < this.resolvers.size(); ++i) {
            ((Resolver)this.resolvers.get(i)).setEDNS(level);
        }
    }

    public void setEDNS(int level, int payloadSize, int flags, List options) {
        for (int i = 0; i < this.resolvers.size(); ++i) {
            ((Resolver)this.resolvers.get(i)).setEDNS(level, payloadSize, flags, options);
        }
    }

    public void setTSIGKey(TSIG key) {
        for (int i = 0; i < this.resolvers.size(); ++i) {
            ((Resolver)this.resolvers.get(i)).setTSIGKey(key);
        }
    }

    public void setTimeout(int secs, int msecs) {
        for (int i = 0; i < this.resolvers.size(); ++i) {
            ((Resolver)this.resolvers.get(i)).setTimeout(secs, msecs);
        }
    }

    public void setTimeout(int secs) {
        this.setTimeout(secs, 0);
    }

    public Message send(Message query) throws IOException {
        Resolution res = new Resolution(this, query);
        return res.start();
    }

    public Object sendAsync(Message query, ResolverListener listener) {
        Resolution res = new Resolution(this, query);
        res.startAsync(listener);
        return res;
    }

    public Resolver getResolver(int n) {
        if (n < this.resolvers.size()) {
            return (Resolver)this.resolvers.get(n);
        }
        return null;
    }

    public Resolver[] getResolvers() {
        return this.resolvers.toArray(new Resolver[this.resolvers.size()]);
    }

    public void addResolver(Resolver r) {
        this.resolvers.add(r);
    }

    public void deleteResolver(Resolver r) {
        this.resolvers.remove(r);
    }

    public void setLoadBalance(boolean flag) {
        this.loadBalance = flag;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    private static class Resolution
    implements ResolverListener {
        Resolver[] resolvers;
        int[] sent;
        Object[] inprogress;
        int retries;
        int outstanding;
        boolean done;
        Message query;
        Message response;
        Throwable thrown;
        ResolverListener listener;

        public Resolution(ExtendedResolver eres, Message query) {
            List l = eres.resolvers;
            this.resolvers = l.toArray(new Resolver[l.size()]);
            if (eres.loadBalance) {
                int nresolvers = this.resolvers.length;
                int start = eres.lbStart++ % nresolvers;
                if (eres.lbStart > nresolvers) {
                    ExtendedResolver extendedResolver = eres;
                    extendedResolver.lbStart = extendedResolver.lbStart % nresolvers;
                }
                if (start > 0) {
                    Resolver[] shuffle = new Resolver[nresolvers];
                    for (int i = 0; i < nresolvers; ++i) {
                        int pos = (i + start) % nresolvers;
                        shuffle[i] = this.resolvers[pos];
                    }
                    this.resolvers = shuffle;
                }
            }
            this.sent = new int[this.resolvers.length];
            this.inprogress = new Object[this.resolvers.length];
            this.retries = eres.retries;
            this.query = query;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void send(int n) {
            int n2 = n;
            this.sent[n2] = this.sent[n2] + 1;
            ++this.outstanding;
            try {
                this.inprogress[n] = this.resolvers[n].sendAsync(this.query, this);
            }
            catch (Throwable t) {
                Resolution resolution = this;
                synchronized (resolution) {
                    this.thrown = t;
                    this.done = true;
                    if (this.listener == null) {
                        this.notifyAll();
                        return;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Message start() throws IOException {
            try {
                this.sent[0] = this.sent[0] + 1;
                ++this.outstanding;
                this.inprogress[0] = new Object();
                return this.resolvers[0].send(this.query);
            }
            catch (Exception e) {
                this.handleException(this.inprogress[0], e);
                Resolution resolution = this;
                synchronized (resolution) {
                    while (!this.done) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                if (this.response != null) {
                    return this.response;
                }
                if (this.thrown instanceof IOException) {
                    throw (IOException)this.thrown;
                }
                if (this.thrown instanceof RuntimeException) {
                    throw (RuntimeException)this.thrown;
                }
                if (this.thrown instanceof Error) {
                    throw (Error)this.thrown;
                }
                throw new IllegalStateException("ExtendedResolver failure");
            }
        }

        public void startAsync(ResolverListener listener) {
            this.listener = listener;
            this.send(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receiveMessage(Object id, Message m3) {
            if (Options.check("verbose")) {
                System.err.println("ExtendedResolver: received message");
            }
            Resolution resolution = this;
            synchronized (resolution) {
                if (this.done) {
                    return;
                }
                this.response = m3;
                this.done = true;
                if (this.listener == null) {
                    this.notifyAll();
                    return;
                }
            }
            this.listener.receiveMessage(this, this.response);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleException(Object id, Exception e) {
            if (Options.check("verbose")) {
                System.err.println("ExtendedResolver: got " + e);
            }
            Resolution resolution = this;
            synchronized (resolution) {
                int n;
                --this.outstanding;
                if (this.done) {
                    return;
                }
                for (n = 0; n < this.inprogress.length && this.inprogress[n] != id; ++n) {
                }
                if (n == this.inprogress.length) {
                    return;
                }
                boolean startnext = false;
                if (this.sent[n] == 1 && n < this.resolvers.length - 1) {
                    startnext = true;
                }
                if (e instanceof InterruptedIOException) {
                    if (this.sent[n] < this.retries) {
                        this.send(n);
                    }
                    if (this.thrown == null) {
                        this.thrown = e;
                    }
                } else if (e instanceof SocketException) {
                    if (this.thrown == null || this.thrown instanceof InterruptedIOException) {
                        this.thrown = e;
                    }
                } else {
                    this.thrown = e;
                }
                if (this.done) {
                    return;
                }
                if (startnext) {
                    this.send(n + 1);
                }
                if (this.done) {
                    return;
                }
                if (this.outstanding == 0) {
                    this.done = true;
                    if (this.listener == null) {
                        this.notifyAll();
                        return;
                    }
                }
                if (!this.done) {
                    return;
                }
            }
            if (!(this.thrown instanceof Exception)) {
                this.thrown = new RuntimeException(this.thrown.getMessage());
            }
            this.listener.handleException(this, (Exception)this.thrown);
        }
    }
}

