/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.as2.inbound;

import com.google.common.io.ByteStreams;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.contrib.web.servlet.filter.TracingFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeMessage;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import network.oxalis.api.error.ErrorTracker;
import network.oxalis.api.model.Direction;
import network.oxalis.as2.inbound.As2InboundHandler;
import network.oxalis.as2.lang.OxalisAs2InboundException;
import network.oxalis.as2.util.MdnBuilder;
import network.oxalis.as2.util.MimeMessageHelper;
import network.oxalis.as2.util.SMimeDigestMethod;
import network.oxalis.as2.util.SMimeMessageFactory;
import network.oxalis.as2.util.SignedMessage;
import network.oxalis.commons.security.CertificateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

@Singleton
class As2Servlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(As2Servlet.class);
    private final Provider<As2InboundHandler> inboundHandlerProvider;
    private final SMimeMessageFactory sMimeMessageFactory;
    private final ErrorTracker errorTracker;
    private final String toIdentifier;
    private final Tracer tracer;

    @Inject
    public As2Servlet(Provider<As2InboundHandler> inboundHandlerProvider, SMimeMessageFactory sMimeMessageFactory, ErrorTracker errorTracker, X509Certificate certificate, Tracer tracer) {
        this.inboundHandlerProvider = inboundHandlerProvider;
        this.sMimeMessageFactory = sMimeMessageFactory;
        this.errorTracker = errorTracker;
        this.toIdentifier = CertificateUtils.extractCommonName(certificate);
        this.tracer = tracer;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (request.getHeader("message-id") == null) {
            response.setStatus(400);
            response.getWriter().println("Header field 'Message-ID' not found.");
            return;
        }
        if (request.getHeader("as2-to") == null) {
            response.setStatus(400);
            response.getWriter().println("Header field 'AS2-To' not found.");
            return;
        }
        if (!this.toIdentifier.equals(request.getHeader("as2-to").replace("\"", "").trim())) {
            response.setStatus(400);
            response.getWriter().println("Invalid value in field 'AS2-To'.");
            return;
        }
        if (request.getHeader("as2-from") == null) {
            response.setStatus(400);
            response.getWriter().println("Header field 'AS2-From' not found.");
            return;
        }
        SpanContext spanContext = (SpanContext)request.getAttribute(TracingFilter.SERVER_SPAN_CONTEXT);
        Span root = this.tracer.buildSpan("as2servlet.post").asChildOf(spanContext).start();
        root.setTag("message-id", request.getHeader("message-id"));
        MDC.put("message-id", request.getHeader("message-id"));
        InternetHeaders headers = new InternetHeaders();
        Collections.list(request.getHeaderNames()).forEach(name -> headers.addHeader((String)name, request.getHeader(name)));
        try {
            MimeMessage mimeMessage = MimeMessageHelper.parse((InputStream)request.getInputStream(), headers);
            try {
                Span span = this.tracer.buildSpan("as2message").asChildOf(root).start();
                MimeMessage mdn = this.inboundHandlerProvider.get().receive(headers, mimeMessage, span);
                span.finish();
                span = this.tracer.buildSpan("mdn").asChildOf(root).start();
                this.writeMdn(response, mdn, 200);
                span.finish();
            }
            catch (OxalisAs2InboundException e) {
                String identifier = this.errorTracker.track(Direction.IN, e, true);
                root.setTag("identifier", identifier);
                root.setTag("exception", String.valueOf(e.getMessage()));
                MdnBuilder mdnBuilder = MdnBuilder.newInstance(mimeMessage);
                mdnBuilder.addHeader("Original-Message-ID", headers.getHeader("Message-Id")[0]);
                mdnBuilder.addHeader("Disposition", e.getDisposition());
                mdnBuilder.addText(String.format("Error [%s]", identifier), e.getMessage());
                MimeMessage mdn = this.sMimeMessageFactory.createSignedMimeMessage(mdnBuilder.build(), SMimeDigestMethod.findByIdentifier(SignedMessage.extractMicalg(mimeMessage)));
                mdn.setHeader("AS2-Version", "1.0");
                mdn.setHeader("AS2-From", this.toIdentifier);
                mdn.setHeader("AS2-To", headers.getHeader("AS2-From")[0]);
                this.writeMdn(response, mdn, 400);
            }
        }
        catch (Exception e) {
            String identifier = this.errorTracker.track(Direction.IN, e, false);
            root.setTag("identifier", identifier);
            root.setTag("exception", String.valueOf(e.getMessage()));
            this.writeFailureWithExplanation(request, response, e);
        }
        MDC.clear();
        root.finish();
    }

    protected void writeMdn(HttpServletResponse response, MimeMessage mdn, int status) throws MessagingException, IOException {
        response.setStatus(status);
        Map<String, String> headers = Collections.list(mdn.getAllHeaders()).stream().map(Header.class::cast).collect(Collectors.toMap(Header::getName, Header::getValue));
        for (String name : headers.keySet()) {
            response.setHeader(name, headers.get(name));
            mdn.removeHeader(name);
        }
        ByteStreams.copy(mdn.getInputStream(), (OutputStream)response.getOutputStream());
    }

    void writeFailureWithExplanation(HttpServletRequest request, HttpServletResponse response, Exception e) throws IOException {
        response.setStatus(500);
        log.error("Request headers:");
        Collections.list(request.getHeaderNames()).forEach(name -> log.error("=> {}: {}", name, (Object)request.getHeader(name)));
        response.getWriter().write("INTERNAL ERROR!!");
        log.error("\n---------- REQUEST FAILURE INFORMATION ENDS HERE --------------");
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setStatus(200);
        response.getOutputStream().println("Hello AS2 world\n");
    }
}

