/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.commons.executor;

import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import network.oxalis.api.settings.Settings;
import network.oxalis.commons.executor.ExecutorConf;
import network.oxalis.commons.guice.OxalisModule;

public class ExecutorModule
extends OxalisModule {
    @Override
    protected void configure() {
        this.bindSettings(ExecutorConf.class);
    }

    @Provides
    @Singleton
    @Named(value="default")
    public ExecutorService getExecutorService(Settings<ExecutorConf> settings) {
        return Executors.newFixedThreadPool(settings.getInt(ExecutorConf.DEFAULT));
    }

    @Provides
    @Singleton
    @Named(value="statistics")
    public ExecutorService getStatisticsExecutorService(Settings<ExecutorConf> settings) {
        return Executors.newFixedThreadPool(settings.getInt(ExecutorConf.STATISTICS));
    }
}

