/*
 * Decompiled with CFR 0.152.
 */
package no.difi.certvalidator.rule;

import java.net.UnknownHostException;
import java.security.cert.X509Certificate;
import net.klakegg.pkix.ocsp.CertificateResult;
import net.klakegg.pkix.ocsp.OcspClient;
import net.klakegg.pkix.ocsp.OcspException;
import net.klakegg.pkix.ocsp.OcspServerException;
import no.difi.certvalidator.api.CertificateBucket;
import no.difi.certvalidator.api.CertificateValidationException;
import no.difi.certvalidator.api.FailedValidationException;
import no.difi.certvalidator.api.Property;
import no.difi.certvalidator.api.Report;
import no.difi.certvalidator.rule.AbstractRule;
import no.difi.certvalidator.util.SimpleProperty;

public class OCSPRule
extends AbstractRule {
    public static final Property<CertificateResult> RESULT = SimpleProperty.create();
    protected OcspClient ocspClient;

    public OCSPRule(CertificateBucket intermediateCertificates) {
        this.ocspClient = OcspClient.builder().set(OcspClient.INTERMEDIATES, intermediateCertificates.asList()).build();
    }

    public OCSPRule(OcspClient ocspClient) {
        this.ocspClient = ocspClient;
    }

    @Override
    public Report validate(X509Certificate certificate, Report report) throws CertificateValidationException {
        try {
            report.set(RESULT, this.ocspClient.verify(certificate));
            return report;
        }
        catch (OcspServerException e) {
            throw new CertificateValidationException(e.getMessage(), e);
        }
        catch (OcspException e) {
            if (e.getCause() instanceof UnknownHostException) {
                throw new CertificateValidationException(e.getMessage(), e);
            }
            throw new FailedValidationException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new CertificateValidationException(e.getMessage(), e);
        }
    }
}

