/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.outbound.transmission;

import io.opentracing.Span;
import io.opentracing.Tracer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.inject.Inject;
import network.oxalis.api.header.HeaderParser;
import network.oxalis.api.lang.OxalisContentException;
import network.oxalis.api.model.Direction;
import network.oxalis.api.outbound.TransmissionMessage;
import network.oxalis.api.tag.Tag;
import network.oxalis.api.tag.TagGenerator;
import network.oxalis.api.transformer.ContentDetector;
import network.oxalis.api.transformer.ContentWrapper;
import network.oxalis.commons.io.PeekingInputStream;
import network.oxalis.commons.tracing.Traceable;
import network.oxalis.outbound.transmission.DefaultTransmissionMessage;
import network.oxalis.vefa.peppol.common.model.Header;

public class TransmissionRequestFactory
extends Traceable {
    private final ContentDetector contentDetector;
    private final ContentWrapper contentWrapper;
    private final TagGenerator tagGenerator;
    private final HeaderParser headerParser;

    @Inject
    public TransmissionRequestFactory(ContentDetector contentDetector, ContentWrapper contentWrapper, TagGenerator tagGenerator, HeaderParser headerParser, Tracer tracer) {
        super(tracer);
        this.contentDetector = contentDetector;
        this.contentWrapper = contentWrapper;
        this.tagGenerator = tagGenerator;
        this.headerParser = headerParser;
    }

    public TransmissionMessage newInstance(InputStream inputStream) throws IOException, OxalisContentException {
        return this.newInstance(inputStream, Tag.NONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransmissionMessage newInstance(InputStream inputStream, Tag tag) throws IOException, OxalisContentException {
        Span root = this.tracer.buildSpan(((Object)((Object)this)).getClass().getSimpleName()).start();
        try {
            TransmissionMessage transmissionMessage = this.perform(inputStream, tag, root);
            return transmissionMessage;
        }
        finally {
            root.finish();
        }
    }

    public TransmissionMessage newInstance(InputStream inputStream, Span root) throws IOException, OxalisContentException {
        return this.newInstance(inputStream, Tag.NONE, root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransmissionMessage newInstance(InputStream inputStream, Tag tag, Span root) throws IOException, OxalisContentException {
        Span span = this.tracer.buildSpan(((Object)((Object)this)).getClass().getSimpleName()).asChildOf(root).start();
        try {
            TransmissionMessage transmissionMessage = this.perform(inputStream, tag, span);
            return transmissionMessage;
        }
        finally {
            span.finish();
        }
    }

    private TransmissionMessage perform(InputStream inputStream, Tag tag, Span root) throws IOException, OxalisContentException {
        PeekingInputStream peekingInputStream = new PeekingInputStream(inputStream);
        try {
            Header header;
            Span span = this.tracer.buildSpan("Reading SBDH").asChildOf(root).start();
            try {
                header = this.headerParser.parse((InputStream)peekingInputStream);
                span.setTag("identifier", header.getIdentifier().getIdentifier());
            }
            catch (OxalisContentException e) {
                span.setTag("exception", e.getMessage());
                throw e;
            }
            finally {
                span.finish();
            }
            return new DefaultTransmissionMessage(header, peekingInputStream.newInputStream(), this.tagGenerator.generate(Direction.OUT, tag));
        }
        catch (OxalisContentException e) {
            InputStream wrappedContent;
            Header header;
            byte[] payload = peekingInputStream.getContent();
            Span span = this.tracer.buildSpan("Detect SBDH from content").asChildOf(root).start();
            try {
                header = this.contentDetector.parse((InputStream)new ByteArrayInputStream(payload));
                span.setTag("identifier", header.getIdentifier().getIdentifier());
            }
            catch (OxalisContentException ex) {
                span.setTag("exception", ex.getMessage());
                throw new OxalisContentException(ex.getMessage(), (Throwable)ex);
            }
            finally {
                span.finish();
            }
            span = this.tracer.buildSpan("Wrap content in SBDH").asChildOf(root).start();
            try {
                wrappedContent = this.contentWrapper.wrap((InputStream)new ByteArrayInputStream(payload), header);
            }
            catch (OxalisContentException ex) {
                span.setTag("exception", ex.getMessage());
                throw ex;
            }
            finally {
                span.finish();
            }
            return new DefaultTransmissionMessage(header, wrappedContent, this.tagGenerator.generate(Direction.OUT, tag));
        }
    }
}

