/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.lookup.locator;

import java.net.URI;
import network.oxalis.vefa.peppol.common.model.ParticipantIdentifier;
import network.oxalis.vefa.peppol.lookup.api.LookupException;
import network.oxalis.vefa.peppol.lookup.api.NotFoundException;
import network.oxalis.vefa.peppol.lookup.locator.AbstractLocator;
import network.oxalis.vefa.peppol.lookup.util.DynamicHostnameGenerator;
import network.oxalis.vefa.peppol.mode.Mode;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.TextParseException;

public class BusdoxLocator
extends AbstractLocator {
    private DynamicHostnameGenerator hostnameGenerator;

    public BusdoxLocator(Mode mode) {
        this(mode.getString("lookup.locator.busdox.prefix"), mode.getString("lookup.locator.hostname"), mode.getString("lookup.locator.busdox.algorithm"));
    }

    public BusdoxLocator(String hostname) {
        this("B-", hostname, "MD5");
    }

    public BusdoxLocator(String prefix, String hostname, String algorithm) {
        this.hostnameGenerator = new DynamicHostnameGenerator(prefix, hostname, algorithm);
    }

    @Override
    public URI lookup(ParticipantIdentifier participantIdentifier) throws LookupException {
        String hostname = this.hostnameGenerator.generate(participantIdentifier);
        try {
            Lookup lookup = new Lookup(hostname);
            if (lookup.run() == null) {
                if (lookup.getResult() == 3) {
                    throw new NotFoundException(String.format("Identifier '%s' is not registered in SML.", participantIdentifier.getIdentifier()));
                }
                throw new LookupException(String.format("Error when looking up identifier '%s' in SML.", participantIdentifier.getIdentifier()));
            }
        }
        catch (TextParseException e) {
            throw new LookupException(e.getMessage(), e);
        }
        return URI.create(String.format("http://%s", hostname));
    }
}

