/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.commons.persist;

import com.google.inject.Injector;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import network.oxalis.api.persist.ExceptionPersister;
import network.oxalis.api.persist.PayloadPersister;
import network.oxalis.api.persist.PersisterHandler;
import network.oxalis.api.persist.ReceiptPersister;
import network.oxalis.api.plugin.PluginFactory;
import network.oxalis.api.settings.Settings;
import network.oxalis.commons.guice.ImplLoader;
import network.oxalis.commons.guice.OxalisModule;
import network.oxalis.commons.persist.DefaultPersister;
import network.oxalis.commons.persist.DefaultPersisterHandler;
import network.oxalis.commons.persist.NoopPersister;
import network.oxalis.commons.persist.PersisterConf;
import network.oxalis.commons.persist.TempPersister;

public class PersisterModule
extends OxalisModule {
    @Override
    protected void configure() {
        this.bindSettings(PersisterConf.class);
        this.bindTyped(PayloadPersister.class, DefaultPersister.class);
        this.bindTyped(ReceiptPersister.class, DefaultPersister.class);
        this.bindTyped(ExceptionPersister.class, DefaultPersister.class);
        this.bindTyped(PersisterHandler.class, DefaultPersisterHandler.class);
        this.bindTyped(PayloadPersister.class, NoopPersister.class);
        this.bindTyped(ReceiptPersister.class, NoopPersister.class);
        this.bindTyped(ExceptionPersister.class, NoopPersister.class);
        this.bindTyped(PersisterHandler.class, NoopPersister.class);
        this.bindTyped(PayloadPersister.class, TempPersister.class);
        this.bindTyped(ReceiptPersister.class, TempPersister.class);
        this.bindTyped(ExceptionPersister.class, TempPersister.class);
        this.bindTyped(PersisterHandler.class, TempPersister.class);
    }

    @Provides
    @Singleton
    @Named(value="plugin")
    protected PayloadPersister getPluginPayloadPersister(PluginFactory pluginFactory) {
        return pluginFactory.newInstance(PayloadPersister.class);
    }

    @Provides
    @Singleton
    @Named(value="plugin")
    protected ReceiptPersister getPluginReceiptPersister(PluginFactory pluginFactory) {
        return pluginFactory.newInstance(ReceiptPersister.class);
    }

    @Provides
    @Singleton
    @Named(value="plugin")
    protected PersisterHandler getPluginPersisterHandler(PluginFactory pluginFactory) {
        return pluginFactory.newInstance(PersisterHandler.class);
    }

    @Provides
    @Singleton
    protected PayloadPersister getPayloadPersister(Injector injector, Settings<PersisterConf> settings) {
        return ImplLoader.get(injector, PayloadPersister.class, settings, PersisterConf.PAYLOAD);
    }

    @Provides
    @Singleton
    protected ReceiptPersister getReceiptPersister(Injector injector, Settings<PersisterConf> settings) {
        return ImplLoader.get(injector, ReceiptPersister.class, settings, PersisterConf.RECEIPT);
    }

    @Provides
    @Singleton
    protected ExceptionPersister getExceptionPersister(Injector injector, Settings<PersisterConf> settings) {
        return ImplLoader.get(injector, ExceptionPersister.class, settings, PersisterConf.EXCEPTION);
    }

    @Provides
    @Singleton
    protected PersisterHandler getPersisterHandler(Injector injector, Settings<PersisterConf> settings) {
        return ImplLoader.get(injector, PersisterHandler.class, settings, PersisterConf.HANDLER);
    }
}

