/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.evidence.rem;

import java.util.Date;
import java.util.List;
import javax.xml.bind.JAXBElement;
import network.oxalis.vefa.peppol.common.model.DocumentTypeIdentifier;
import network.oxalis.vefa.peppol.common.model.InstanceIdentifier;
import network.oxalis.vefa.peppol.common.model.ParticipantIdentifier;
import network.oxalis.vefa.peppol.common.model.Scheme;
import network.oxalis.vefa.peppol.common.util.ExceptionUtil;
import network.oxalis.vefa.peppol.evidence.jaxb.receipt.PeppolRemExtension;
import network.oxalis.vefa.peppol.evidence.jaxb.rem.AttributedElectronicAddressType;
import network.oxalis.vefa.peppol.evidence.jaxb.rem.EntityDetailsListType;
import network.oxalis.vefa.peppol.evidence.jaxb.rem.EntityDetailsType;
import network.oxalis.vefa.peppol.evidence.jaxb.rem.REMEvidenceType;
import network.oxalis.vefa.peppol.evidence.lang.RemEvidenceException;
import network.oxalis.vefa.peppol.evidence.rem.EventCode;
import network.oxalis.vefa.peppol.evidence.rem.EventReason;
import network.oxalis.vefa.peppol.evidence.rem.EvidenceTypeInstance;
import network.oxalis.vefa.peppol.evidence.rem.RemHelper;
import org.w3c.dom.Document;

public class SignedRemEvidence {
    private final JAXBElement<REMEvidenceType> jaxbElement;
    private final Document signedRemEvidenceXml;

    public SignedRemEvidence(JAXBElement<REMEvidenceType> jaxbElement, Document signedRemEvidenceXml) {
        this.jaxbElement = jaxbElement;
        this.signedRemEvidenceXml = signedRemEvidenceXml;
    }

    public REMEvidenceType getRemEvidenceType() {
        return this.e();
    }

    public Document getDocument() {
        return this.signedRemEvidenceXml;
    }

    public EvidenceTypeInstance getEvidenceType() {
        return EvidenceTypeInstance.findByLocalName(this.signedRemEvidenceXml.getDocumentElement().getLocalName());
    }

    public String getEvidenceIdentifier() {
        return this.e().getEvidenceIdentifier();
    }

    public EventCode getEventCode() {
        return EventCode.valueFor(this.e().getEventCode());
    }

    public EventReason getEventReason() {
        return EventReason.valueForCode(this.e().getEventReasons().getEventReason().get(0).getCode());
    }

    public Date getEventTime() {
        return this.e().getEventTime().toGregorianCalendar().getTime();
    }

    public String getEvidenceIssuerPolicyID() throws RemEvidenceException {
        if (this.e().getEvidenceIssuerPolicyID() == null) {
            throw new RemEvidenceException("Evidence issuer policy ID is not set");
        }
        return this.e().getEvidenceIssuerPolicyID().getPolicyID().get(0);
    }

    public String getEvidenceIssuerDetails() throws RemEvidenceException {
        return ExceptionUtil.perform(RemEvidenceException.class, "There are no Event Issuer Details", () -> this.e().getEvidenceIssuerDetails().getNamesPostalAddresses().getNamePostalAddress().get(0).getEntityName().getName().get(0));
    }

    public ParticipantIdentifier getSenderIdentifier() {
        EntityDetailsType senderDetails = this.e().getSenderDetails();
        List<Object> attributedElectronicAddressOrElectronicAddress = senderDetails.getAttributedElectronicAddressOrElectronicAddress();
        return RemHelper.readElectronicAddressType((AttributedElectronicAddressType)attributedElectronicAddressOrElectronicAddress.get(0));
    }

    private REMEvidenceType e() {
        return (REMEvidenceType)this.jaxbElement.getValue();
    }

    public ParticipantIdentifier getRecipientIdentifier() {
        EntityDetailsListType entityDetailsListType = this.e().getRecipientsDetails();
        EntityDetailsType entityDetailsType = entityDetailsListType.getEntityDetails().get(0);
        List<Object> objectList = entityDetailsType.getAttributedElectronicAddressOrElectronicAddress();
        return RemHelper.readElectronicAddressType((AttributedElectronicAddressType)objectList.get(0));
    }

    public DocumentTypeIdentifier getDocumentTypeIdentifier() {
        return DocumentTypeIdentifier.of(this.e().getSenderMessageDetails().getMessageSubject(), Scheme.NONE);
    }

    public String getDocumentTypeInstanceIdentifier() {
        return this.e().getSenderMessageDetails().getUAMessageIdentifier();
    }

    public InstanceIdentifier getInstanceIdentifier() {
        return InstanceIdentifier.of(this.e().getSenderMessageDetails().getMessageIdentifierByREMMD());
    }

    public byte[] getPayloadDigestValue() {
        return this.e().getSenderMessageDetails().getDigestValue();
    }

    public PeppolRemExtension getTransmissionEvidence() {
        return (PeppolRemExtension)this.e().getExtensions().getExtension().get(0).getContent().get(0);
    }
}

