/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.lookup.fetcher;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import network.oxalis.vefa.peppol.lookup.api.FetcherResponse;
import network.oxalis.vefa.peppol.lookup.api.LookupException;
import network.oxalis.vefa.peppol.lookup.fetcher.AbstractFetcher;
import network.oxalis.vefa.peppol.mode.Mode;

public class UrlFetcher
extends AbstractFetcher {
    public UrlFetcher(Mode mode) {
        super(mode);
    }

    @Override
    public FetcherResponse fetch(URI uri) throws LookupException, FileNotFoundException {
        try {
            HttpURLConnection urlConnection = (HttpURLConnection)uri.toURL().openConnection();
            urlConnection.setConnectTimeout(this.timeout);
            urlConnection.setReadTimeout(this.timeout);
            if (urlConnection.getResponseCode() != 200) {
                throw new LookupException(String.format("Received code '%s' from SMP.", urlConnection.getResponseCode()));
            }
            return new FetcherResponse(new BufferedInputStream(urlConnection.getInputStream()), urlConnection.getHeaderField("X-SMP-Namespace"));
        }
        catch (FileNotFoundException e) {
            throw new FileNotFoundException(uri.toString());
        }
        catch (SocketException | SocketTimeoutException e) {
            throw new LookupException(String.format("Unable to fetch '%s'", uri), e);
        }
        catch (IOException e) {
            throw new LookupException(e.getMessage(), e);
        }
    }
}

