/*
 * Decompiled with CFR 0.152.
 */
package no.difi.certvalidator.rule;

import java.io.IOException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import no.difi.certvalidator.api.CertificateValidationException;
import no.difi.certvalidator.api.CrlCache;
import no.difi.certvalidator.api.CrlFetcher;
import no.difi.certvalidator.api.FailedValidationException;
import no.difi.certvalidator.rule.AbstractRule;
import no.difi.certvalidator.util.SimpleCachingCrlFetcher;
import no.difi.certvalidator.util.SimpleCrlCache;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.x509.extension.X509ExtensionUtil;

public class CRLRule
extends AbstractRule {
    private static final String CRL_EXTENSION = "2.5.29.31";
    private CrlFetcher crlFetcher;

    public CRLRule(CrlFetcher crlFetcher) {
        this.crlFetcher = crlFetcher;
    }

    public CRLRule(CrlCache crlCache) {
        this(new SimpleCachingCrlFetcher(crlCache));
    }

    public CRLRule() {
        this.crlFetcher = new SimpleCachingCrlFetcher(new SimpleCrlCache());
    }

    @Override
    public void validate(X509Certificate certificate) throws CertificateValidationException {
        List<String> urls = CRLRule.getCrlDistributionPoints(certificate);
        for (String url : urls) {
            X509CRL crl = this.crlFetcher.get(url);
            if (crl == null || !crl.isRevoked(certificate)) continue;
            throw new FailedValidationException("Certificate is revoked.");
        }
    }

    public static List<String> getCrlDistributionPoints(X509Certificate certificate) throws CertificateValidationException {
        try {
            ArrayList<String> urls = new ArrayList<String>();
            if (!certificate.getNonCriticalExtensionOIDs().contains(CRL_EXTENSION)) {
                return urls;
            }
            CRLDistPoint distPoint = CRLDistPoint.getInstance(X509ExtensionUtil.fromExtensionValue(certificate.getExtensionValue(CRL_EXTENSION)));
            for (DistributionPoint dp : distPoint.getDistributionPoints()) {
                for (GeneralName name : ((GeneralNames)dp.getDistributionPoint().getName()).getNames()) {
                    if (name.getTagNo() != 6) continue;
                    urls.add(((DERIA5String)name.getName()).getString());
                }
            }
            return urls;
        }
        catch (IOException | NullPointerException e) {
            throw new CertificateValidationException(e.getMessage(), e);
        }
    }
}

