/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.as2.outbound;

import com.google.common.io.ByteStreams;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import io.opentracing.Span;
import io.opentracing.Tracer;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import network.oxalis.api.identifier.MessageIdGenerator;
import network.oxalis.api.lang.OxalisTransmissionException;
import network.oxalis.api.model.TransmissionIdentifier;
import network.oxalis.api.outbound.TransmissionRequest;
import network.oxalis.api.outbound.TransmissionResponse;
import network.oxalis.api.timestamp.TimestampProvider;
import network.oxalis.as2.model.As2DispositionNotificationOptions;
import network.oxalis.as2.util.As2DateUtil;
import network.oxalis.as2.util.MessageIdUtil;
import network.oxalis.as2.util.MimeMessageHelper;
import network.oxalis.as2.util.SMimeDigestMethod;
import network.oxalis.as2.util.SMimeMessageFactory;
import network.oxalis.commons.security.CertificateUtils;
import network.oxalis.commons.tracing.Traceable;
import network.oxalis.vefa.peppol.common.model.Digest;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class As2MessageSender
extends Traceable {
    private static final Logger log = LoggerFactory.getLogger(As2MessageSender.class);
    private final Provider<CloseableHttpClient> httpClientProvider;
    private final SMimeMessageFactory sMimeMessageFactory;
    private final TimestampProvider timestampProvider;
    private final String notificationAddress;
    private final MessageIdGenerator messageIdGenerator;
    private final String fromIdentifier;
    private TransmissionRequest transmissionRequest;
    private TransmissionIdentifier transmissionIdentifier;
    private Span root;
    private Digest outboundMic;

    @Inject
    public As2MessageSender(Provider<CloseableHttpClient> httpClientProvider, X509Certificate certificate, SMimeMessageFactory sMimeMessageFactory, TimestampProvider timestampProvider, @Named(value="as2-notification") String notificationAddress, MessageIdGenerator messageIdGenerator, Tracer tracer) {
        super(tracer);
        this.httpClientProvider = httpClientProvider;
        this.sMimeMessageFactory = sMimeMessageFactory;
        this.timestampProvider = timestampProvider;
        this.notificationAddress = notificationAddress;
        this.messageIdGenerator = messageIdGenerator;
        this.fromIdentifier = CertificateUtils.extractCommonName(certificate);
    }

    public TransmissionResponse send(TransmissionRequest transmissionRequest, Span root) throws OxalisTransmissionException {
        this.transmissionRequest = transmissionRequest;
        this.root = this.tracer.buildSpan("Send AS2 message").asChildOf(root).start();
        try {
            TransmissionResponse transmissionResponse = this.sendHttpRequest(this.prepareHttpRequest());
            return transmissionResponse;
        }
        catch (OxalisTransmissionException e) {
            this.root.setTag("exception", e.getMessage());
            throw e;
        }
        finally {
            root.finish();
        }
    }

    protected HttpPost prepareHttpRequest() throws OxalisTransmissionException {
        Span span = this.tracer.buildSpan("request").asChildOf(this.root).start();
        try {
            MimeBodyPart mimeBodyPart = MimeMessageHelper.createMimeBodyPart(this.transmissionRequest.getPayload(), "application/xml");
            SMimeDigestMethod digestMethod = SMimeDigestMethod.findByTransportProfile(this.transmissionRequest.getEndpoint().getTransportProfile());
            this.outboundMic = MimeMessageHelper.calculateMic(mimeBodyPart, digestMethod);
            span.setTag("mic", this.outboundMic.toString());
            span.setTag("endpoint url", this.transmissionRequest.getEndpoint().getAddress().toString());
            String messageId = this.messageIdGenerator.generate(this.transmissionRequest);
            if (!MessageIdUtil.verify(messageId)) {
                throw new OxalisTransmissionException("Invalid Message-ID '" + messageId + "' generated.");
            }
            span.setTag("message-id", messageId);
            this.transmissionIdentifier = TransmissionIdentifier.fromHeader(messageId);
            MimeMessage signedMimeMessage = this.sMimeMessageFactory.createSignedMimeMessage(mimeBodyPart, digestMethod);
            Map<String, String> headers = Collections.list(signedMimeMessage.getAllHeaders()).stream().collect(Collectors.toMap(Header::getName, h2 -> h2.getValue().replace("\r\n\t", "")));
            for (String name : headers.keySet()) {
                signedMimeMessage.removeHeader(name);
            }
            HttpPost httpPost = new HttpPost(this.transmissionRequest.getEndpoint().getAddress());
            ByteArrayEntity httpEntity = new ByteArrayEntity(ByteStreams.toByteArray(signedMimeMessage.getInputStream()));
            httpPost.setEntity(httpEntity);
            httpPost.addHeader("Message-Id", messageId);
            httpPost.addHeader("MIME-Version", headers.get("MIME-Version"));
            httpPost.addHeader("Content-Type", headers.get("Content-Type"));
            httpPost.addHeader("AS2-From", this.fromIdentifier);
            httpPost.setHeader("AS2-To", CertificateUtils.extractCommonName(this.transmissionRequest.getEndpoint().getCertificate()));
            httpPost.addHeader("Disposition-Notification-To", this.notificationAddress);
            httpPost.addHeader("Disposition-Notification-Options", As2DispositionNotificationOptions.getDefault(digestMethod).toString());
            httpPost.addHeader("AS2-Version", "1.0");
            httpPost.addHeader("Subject", "AS2 message from Oxalis");
            httpPost.addHeader("Date", As2DateUtil.RFC822.format(new Date()));
            HttpPost httpPost2 = httpPost;
            return httpPost2;
        }
        catch (IOException | MessagingException e) {
            throw new OxalisTransmissionException("Unexpected error during preparation of AS2 message.", (Throwable)e);
        }
        finally {
            span.finish();
        }
    }

    /*
     * Exception decompiling
     */
    protected TransmissionResponse sendHttpRequest(HttpPost httpPost) throws OxalisTransmissionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected TransmissionResponse handleResponse(CloseableHttpResponse closeableHttpResponse) throws OxalisTransmissionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void handleFailedRequest(HttpResponse response) throws OxalisTransmissionException {
        HttpEntity entity = response.getEntity();
        try {
            if (entity == null) {
                throw new OxalisTransmissionException(String.format("Request failed with rc=%s, no content returned in HTTP response", response.getStatusLine().getStatusCode()));
            }
            String contents = EntityUtils.toString(entity);
            throw new OxalisTransmissionException(String.format("Request failed with rc=%s, contents received (%s characters): %s", response.getStatusLine().getStatusCode(), contents.trim().length(), contents));
        }
        catch (IOException e) {
            throw new OxalisTransmissionException(String.format("Request failed with rc=%s, ERROR while retrieving the contents of the response: %s", response.getStatusLine().getStatusCode(), e.getMessage()), (Throwable)e);
        }
    }
}

