/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.commons.mode;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.typesafe.config.Config;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.contrib.spanmanager.DefaultSpanManager;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import net.klakegg.pkix.ocsp.api.OcspFetcher;
import network.oxalis.api.lang.OxalisLoadingException;
import network.oxalis.vefa.peppol.common.lang.PeppolLoadingException;
import network.oxalis.vefa.peppol.mode.Mode;
import network.oxalis.vefa.peppol.security.ModeDetector;
import no.difi.certvalidator.api.CrlFetcher;

public class ModeProvider
implements Provider<Mode> {
    @Inject
    private X509Certificate certificate;
    @Inject
    private Config config;
    @Inject
    private OcspFetcher ocspFetcher;
    @Inject
    private CrlFetcher crlFetcher;
    @Inject
    private Tracer tracer;

    @Override
    public Mode get() {
        Span span = this.tracer.buildSpan("Mode detection").start();
        DefaultSpanManager.getInstance().activate(span);
        try {
            HashMap<String, Object> objectStorage = new HashMap<String, Object>();
            objectStorage.put("ocsp_fetcher", this.ocspFetcher);
            objectStorage.put("crlFetcher", this.crlFetcher);
            Mode mode = ModeDetector.detect(this.certificate, this.config, objectStorage);
            return mode;
        }
        catch (PeppolLoadingException e) {
            throw new OxalisLoadingException("Unable to detect mode.", e);
        }
        finally {
            span.finish();
        }
    }
}

