/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.commons.evidence;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.OutputStream;
import java.security.KeyStore;
import network.oxalis.api.evidence.EvidenceFactory;
import network.oxalis.api.lang.EvidenceException;
import network.oxalis.api.outbound.TransmissionResponse;
import network.oxalis.api.transmission.TransmissionResult;
import network.oxalis.api.util.Type;
import network.oxalis.commons.util.OxalisVersion;
import network.oxalis.vefa.peppol.common.model.InstanceIdentifier;
import network.oxalis.vefa.peppol.evidence.jaxb.receipt.TransmissionRole;
import network.oxalis.vefa.peppol.evidence.lang.RemEvidenceException;
import network.oxalis.vefa.peppol.evidence.rem.EventCode;
import network.oxalis.vefa.peppol.evidence.rem.Evidence;
import network.oxalis.vefa.peppol.evidence.rem.EvidenceTypeInstance;
import network.oxalis.vefa.peppol.evidence.rem.SignedEvidenceWriter;
import network.oxalis.vefa.peppol.security.lang.PeppolSecurityException;

@Singleton
@Type(value={"rem"})
public class RemEvidenceFactory
implements EvidenceFactory {
    private static final String ISSUER = String.format("Oxalis %s", OxalisVersion.getVersion());
    private final KeyStore.PrivateKeyEntry privateKeyEntry;

    @Inject
    public RemEvidenceFactory(KeyStore.PrivateKeyEntry privateKeyEntry) {
        this.privateKeyEntry = privateKeyEntry;
    }

    @Override
    public void write(OutputStream outputStream, TransmissionResult transmissionResult) throws EvidenceException {
        try {
            Evidence evidence = Evidence.newInstance().type(EvidenceTypeInstance.DELIVERY_NON_DELIVERY_TO_RECIPIENT).eventCode(EventCode.DELIVERY).issuer(ISSUER).evidenceIdentifier(InstanceIdentifier.generateUUID()).timestamp(transmissionResult.getTimestamp()).header(transmissionResult.getHeader()).digest(transmissionResult.getDigest()).messageIdentifier(transmissionResult.getTransmissionIdentifier()).transportProtocol(transmissionResult.getTransportProtocol()).transmissionRole(transmissionResult instanceof TransmissionResponse ? TransmissionRole.C_2 : TransmissionRole.C_3).originalReceipts(transmissionResult.getReceipts());
            SignedEvidenceWriter.write(outputStream, this.privateKeyEntry, evidence);
        }
        catch (RemEvidenceException | PeppolSecurityException e) {
            throw new EvidenceException(e.getMessage(), e);
        }
    }
}

