/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.commons.identifier;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import network.oxalis.api.identifier.MessageIdGenerator;
import network.oxalis.api.settings.Settings;
import network.oxalis.commons.guice.ImplLoader;
import network.oxalis.commons.guice.OxalisModule;
import network.oxalis.commons.identifier.DefaultMessageIdGenerator;
import network.oxalis.commons.identifier.HostnameProvider;
import network.oxalis.commons.identifier.IdentifierConf;

public class IdentifierModule
extends OxalisModule {
    @Override
    protected void configure() {
        this.bind(Key.get(String.class, (Annotation)Names.named("hostname"))).toProvider(HostnameProvider.class).in(Singleton.class);
        this.bindTyped(MessageIdGenerator.class, DefaultMessageIdGenerator.class);
        this.bindSettings(IdentifierConf.class);
    }

    @Provides
    @Singleton
    public MessageIdGenerator getMessageIdGenerator(Injector injector, Settings<IdentifierConf> settings) {
        return ImplLoader.get(injector, MessageIdGenerator.class, settings, IdentifierConf.MSGID_GENERATOR);
    }
}

