/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.sniffer.document;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PlainUBLParser {
    private final Document document;
    private final XPath xPath;

    public PlainUBLParser(Document document, XPath xPath) {
        this.document = document;
        this.xPath = xPath;
    }

    public String localName() {
        return this.document.getDocumentElement().getLocalName();
    }

    public String rootNameSpace() {
        return this.document.getDocumentElement().getNamespaceURI();
    }

    public String ublVersion() {
        return this.retriveValueForXpath("//cbc:UBLVersionID");
    }

    public boolean canParse() {
        return ("" + this.rootNameSpace()).startsWith("urn:oasis:names:specification:ubl:schema:xsd:");
    }

    public Element retrieveElementForXpath(String s2) {
        try {
            Element element = (Element)this.xPath.evaluate(s2, this.document, XPathConstants.NODE);
            if (element == null) {
                throw new IllegalStateException("No element in XPath: " + s2);
            }
            return element;
        }
        catch (XPathExpressionException e) {
            throw new IllegalStateException("Unable to evaluate " + s2 + "; " + e.getMessage(), e);
        }
    }

    public String retriveValueForXpath(String s2) {
        try {
            String value = this.xPath.evaluate(s2, this.document);
            if (value == null) {
                throw new IllegalStateException("Unable to find value for Xpath expr " + s2);
            }
            return value.trim();
        }
        catch (XPathExpressionException e) {
            throw new IllegalStateException("Unable to evaluate " + s2 + "; " + e.getMessage(), e);
        }
    }
}

