/*
 * Decompiled with CFR 0.152.
 */
package no.difi.certvalidator.rule;

import java.security.cert.X509Certificate;
import no.difi.certvalidator.api.CertificateBucket;
import no.difi.certvalidator.api.CertificateValidationException;
import no.difi.certvalidator.api.FailedValidationException;
import no.difi.certvalidator.rule.AbstractRule;

public class WhitelistRule
extends AbstractRule {
    private final CertificateBucket certificates;

    public WhitelistRule(CertificateBucket certificates) {
        this.certificates = certificates;
    }

    @Override
    public void validate(X509Certificate certificate) throws CertificateValidationException {
        for (X509Certificate cert : this.certificates) {
            if (!cert.equals(certificate)) continue;
            return;
        }
        throw new FailedValidationException("Certificate is not in whitelist.");
    }
}

