/*
 * Decompiled with CFR 0.152.
 */
package brave.opentracing;

import brave.Span;
import brave.Tracer;
import brave.opentracing.BraveScope;
import brave.opentracing.BraveSpan;
import brave.opentracing.BraveSpanContext;
import brave.propagation.TraceContext;
import brave.sampler.Sampler;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.tag.Tag;
import io.opentracing.tag.Tags;
import java.util.LinkedHashMap;
import java.util.Map;

public class BraveSpanBuilder
implements Tracer.SpanBuilder {
    final Tracer tracer;
    final Map<String, String> tags = new LinkedHashMap<String, String>();
    String operationName;
    long timestamp;
    int remotePort;
    BraveSpanContext reference;
    boolean ignoreActiveSpan = false;

    BraveSpanBuilder(Tracer tracer, String operationName) {
        this.tracer = tracer;
        this.operationName = operationName;
    }

    @Override
    public BraveSpanBuilder asChildOf(SpanContext parent) {
        return this.addReference("child_of", parent);
    }

    @Override
    public BraveSpanBuilder asChildOf(io.opentracing.Span parent) {
        return this.asChildOf(parent != null ? parent.context() : null);
    }

    @Override
    public BraveSpanBuilder addReference(String type, SpanContext context) {
        if (this.reference != null || context == null) {
            return this;
        }
        if ("child_of".equals(type) || "follows_from".equals(type)) {
            this.reference = (BraveSpanContext)context;
        }
        return this;
    }

    @Override
    public BraveSpanBuilder withTag(String key, String value) {
        this.tags.put(key, value);
        return this;
    }

    @Override
    public BraveSpanBuilder withTag(String key, boolean value) {
        if (Tags.ERROR.getKey().equals(key) && !value) {
            return this;
        }
        return this.withTag(key, Boolean.toString(value));
    }

    @Override
    public BraveSpanBuilder withTag(String key, Number value) {
        if (Tags.PEER_PORT.getKey().equals(key)) {
            this.remotePort = value.intValue();
            return this;
        }
        return this.withTag(key, value.toString());
    }

    @Override
    public <T> BraveSpanBuilder withTag(Tag<T> tag, T value) {
        if (tag == null) {
            throw new NullPointerException("tag == null");
        }
        if (value == null) {
            throw new NullPointerException("value == null");
        }
        if (value instanceof String) {
            return this.withTag(tag.getKey(), (String)value);
        }
        if (value instanceof Number) {
            return this.withTag(tag.getKey(), (Number)value);
        }
        if (value instanceof Boolean) {
            return this.withTag(tag.getKey(), (Boolean)value);
        }
        throw new IllegalArgumentException("tag value not a string, number or boolean: " + value);
    }

    @Override
    public BraveSpanBuilder withStartTimestamp(long microseconds) {
        this.timestamp = microseconds;
        return this;
    }

    @Override
    public BraveSpanBuilder ignoreActiveSpan() {
        this.ignoreActiveSpan = true;
        return this;
    }

    @Override
    public BraveSpan start() {
        Span span;
        Span parent;
        boolean server = "server".equals(this.tags.get(Tags.SPAN_KIND.getKey()));
        if (this.reference == null && !this.ignoreActiveSpan && (parent = this.tracer.currentSpan()) != null) {
            this.asChildOf(BraveSpanContext.create(parent.context()));
        }
        if (this.reference == null) {
            Tracer scopedTracer = this.tracer;
            String sampling = this.tags.get(Tags.SAMPLING_PRIORITY.getKey());
            if (sampling != null) {
                try {
                    Integer samplingPriority = Integer.valueOf(sampling);
                    if (samplingPriority == 0) {
                        scopedTracer = this.tracer.withSampler(Sampler.NEVER_SAMPLE);
                    } else if (samplingPriority > 0) {
                        scopedTracer = this.tracer.withSampler(Sampler.ALWAYS_SAMPLE);
                    }
                }
                catch (NumberFormatException samplingPriority) {
                    // empty catch block
                }
            }
            span = scopedTracer.newTrace();
        } else {
            TraceContext context = this.reference.unwrap();
            span = context != null ? (server ? this.tracer.joinSpan(context) : this.tracer.newChild(context)) : this.tracer.nextSpan(((BraveSpanContext.Incomplete)this.reference).extractionResult());
        }
        if (this.operationName != null) {
            span.name(this.operationName);
        }
        BraveSpan result = new BraveSpan(this.tracer, span);
        result.remotePort = this.remotePort;
        for (Map.Entry<String, String> tag : this.tags.entrySet()) {
            result.setTag(tag.getKey(), tag.getValue());
        }
        if (this.timestamp != 0L) {
            span.start(this.timestamp);
        } else {
            span.start();
        }
        return result;
    }

    @Deprecated
    public BraveSpan startManual() {
        throw new UnsupportedOperationException("Not supported in OpenTracing 0.33+");
    }

    @Deprecated
    public BraveScope startActive(boolean finishSpanOnClose) {
        throw new UnsupportedOperationException("Not supported in OpenTracing 0.33+");
    }
}

