/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.commons.mode;

import com.google.inject.Provides;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.inject.Named;
import network.oxalis.api.lang.OxalisLoadingException;
import network.oxalis.commons.certvalidator.api.CrlCache;
import network.oxalis.commons.certvalidator.api.CrlFetcher;
import network.oxalis.commons.certvalidator.util.SimpleCrlCache;
import network.oxalis.commons.guice.OxalisModule;
import network.oxalis.commons.mode.ModeProvider;
import network.oxalis.commons.mode.OxalisCrlFetcher;
import network.oxalis.commons.mode.OxalisOcspFetcher;
import network.oxalis.pkix.ocsp.api.OcspFetcher;
import network.oxalis.vefa.peppol.common.lang.PeppolLoadingException;
import network.oxalis.vefa.peppol.mode.Mode;
import network.oxalis.vefa.peppol.security.api.CertificateValidator;
import org.apache.http.client.config.RequestConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModeModule
extends OxalisModule {
    private static final Logger log = LoggerFactory.getLogger(ModeModule.class);

    @Override
    protected void configure() {
        this.bind(OcspFetcher.class).to(OxalisOcspFetcher.class);
        this.bind(CrlCache.class).toInstance(new SimpleCrlCache());
        this.bind(CrlFetcher.class).to(OxalisCrlFetcher.class);
        this.bind(Mode.class).toProvider(ModeProvider.class).asEagerSingleton();
    }

    @Provides
    @Singleton
    protected CertificateValidator getCertificateValidator(Mode mode) throws PeppolLoadingException {
        return mode.initiate("security.validator.class", CertificateValidator.class);
    }

    @Provides
    @Singleton
    @Named(value="certificate")
    protected RequestConfig getRequestConfig() {
        return RequestConfig.custom().setConnectTimeout(10000).setConnectionRequestTimeout(10000).setSocketTimeout(10000).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Provides
    @Singleton
    @Named(value="truststore-ap")
    protected KeyStore getTruststoreAp(Mode mode) {
        try (InputStream inputStream = this.getClass().getResourceAsStream(mode.getString("security.truststore.ap"));){
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(inputStream, mode.getString("security.truststore.password").toCharArray());
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new OxalisLoadingException("Unable to load truststore for AP.", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Provides
    @Singleton
    @Named(value="truststore-smp")
    protected KeyStore getTruststoreSmp(Mode mode) {
        try (InputStream inputStream = this.getClass().getResourceAsStream(mode.getString("security.truststore.smp"));){
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(inputStream, mode.getString("security.truststore.password").toCharArray());
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new OxalisLoadingException("Unable to load truststore for SMP.", e);
        }
    }
}

