/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.web.servlet.filter;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.contrib.web.servlet.filter.HttpServletRequestExtractAdapter;
import io.opentracing.contrib.web.servlet.filter.ServletFilterSpanDecorator;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tags;
import io.opentracing.util.GlobalTracer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TracingFilter
implements Filter {
    private static final Logger log = Logger.getLogger(TracingFilter.class.getName());
    public static final String SPAN_DECORATORS = TracingFilter.class.getName() + ".spanDecorators";
    public static final String SKIP_PATTERN = TracingFilter.class.getName() + ".skipPattern";
    public static final String SERVER_SPAN_CONTEXT = TracingFilter.class.getName() + ".activeSpanContext";
    private FilterConfig filterConfig;
    protected Tracer tracer;
    private List<ServletFilterSpanDecorator> spanDecorators;
    private Pattern skipPattern;

    public TracingFilter() {
        this(GlobalTracer.get());
    }

    public TracingFilter(Tracer tracer) {
        this(tracer, Collections.singletonList(ServletFilterSpanDecorator.STANDARD_TAGS), null);
    }

    public TracingFilter(Tracer tracer, List<ServletFilterSpanDecorator> spanDecorators, Pattern skipPattern) {
        this.tracer = tracer;
        this.spanDecorators = new ArrayList<ServletFilterSpanDecorator>(spanDecorators);
        this.spanDecorators.removeAll(Collections.singleton(null));
        this.skipPattern = skipPattern;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        ServletContext servletContext = filterConfig.getServletContext();
        Object tracerObj = servletContext.getAttribute(Tracer.class.getName());
        if (tracerObj instanceof Tracer) {
            this.tracer = (Tracer)tracerObj;
        } else {
            servletContext.setAttribute(Tracer.class.getName(), (Object)this.tracer);
        }
        Object contextAttribute = servletContext.getAttribute(SPAN_DECORATORS);
        if (contextAttribute instanceof Collection) {
            ArrayList<ServletFilterSpanDecorator> decorators = new ArrayList<ServletFilterSpanDecorator>();
            for (Object decorator : (Collection)contextAttribute) {
                if (decorator instanceof ServletFilterSpanDecorator) {
                    decorators.add((ServletFilterSpanDecorator)decorator);
                    continue;
                }
                log.severe(decorator + " is not an instance of " + ServletFilterSpanDecorator.class);
            }
            List<ServletFilterSpanDecorator> list = this.spanDecorators = decorators.size() > 0 ? decorators : this.spanDecorators;
        }
        if ((contextAttribute = servletContext.getAttribute(SKIP_PATTERN)) instanceof Pattern) {
            this.skipPattern = (Pattern)contextAttribute;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpResponse = (HttpServletResponse)servletResponse;
        if (!this.isTraced(httpRequest, httpResponse)) {
            chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            return;
        }
        if (servletRequest.getAttribute(SERVER_SPAN_CONTEXT) != null) {
            chain.doFilter(servletRequest, servletResponse);
            return;
        }
        SpanContext extractedContext = this.tracer.extract(Format.Builtin.HTTP_HEADERS, new HttpServletRequestExtractAdapter(httpRequest));
        Span span = this.tracer.buildSpan(httpRequest.getMethod()).asChildOf(extractedContext).withTag(Tags.SPAN_KIND.getKey(), "server").start();
        httpRequest.setAttribute(SERVER_SPAN_CONTEXT, (Object)span.context());
        for (ServletFilterSpanDecorator spanDecorator : this.spanDecorators) {
            spanDecorator.onRequest(httpRequest, span);
        }
        try {
            Scope scope = this.tracer.activateSpan(span);
            Object object = null;
            try {
                chain.doFilter(servletRequest, servletResponse);
                if (!httpRequest.isAsyncStarted()) {
                    for (ServletFilterSpanDecorator spanDecorator : this.spanDecorators) {
                        spanDecorator.onResponse(httpRequest, httpResponse, span);
                    }
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (scope != null) {
                    if (object != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        scope.close();
                    }
                }
            }
        }
        catch (Throwable ex) {
            try {
                for (ServletFilterSpanDecorator spanDecorator : this.spanDecorators) {
                    spanDecorator.onError(httpRequest, httpResponse, ex, span);
                }
                throw ex;
            }
            catch (Throwable throwable) {
                if (httpRequest.isAsyncStarted()) {
                    httpRequest.getAsyncContext().addListener(new AsyncListener(span){
                        final /* synthetic */ Span val$span;
                        {
                            this.val$span = span;
                        }

                        public void onComplete(AsyncEvent event) throws IOException {
                            HttpServletRequest httpRequest = (HttpServletRequest)event.getSuppliedRequest();
                            HttpServletResponse httpResponse = (HttpServletResponse)event.getSuppliedResponse();
                            for (ServletFilterSpanDecorator spanDecorator : TracingFilter.this.spanDecorators) {
                                spanDecorator.onResponse(httpRequest, httpResponse, this.val$span);
                            }
                            this.val$span.finish();
                        }

                        public void onTimeout(AsyncEvent event) throws IOException {
                            HttpServletRequest httpRequest = (HttpServletRequest)event.getSuppliedRequest();
                            HttpServletResponse httpResponse = (HttpServletResponse)event.getSuppliedResponse();
                            for (ServletFilterSpanDecorator spanDecorator : TracingFilter.this.spanDecorators) {
                                spanDecorator.onTimeout(httpRequest, httpResponse, event.getAsyncContext().getTimeout(), this.val$span);
                            }
                        }

                        public void onError(AsyncEvent event) throws IOException {
                            HttpServletRequest httpRequest = (HttpServletRequest)event.getSuppliedRequest();
                            HttpServletResponse httpResponse = (HttpServletResponse)event.getSuppliedResponse();
                            for (ServletFilterSpanDecorator spanDecorator : TracingFilter.this.spanDecorators) {
                                spanDecorator.onError(httpRequest, httpResponse, event.getThrowable(), this.val$span);
                            }
                        }

                        public void onStartAsync(AsyncEvent event) throws IOException {
                        }
                    });
                    throw throwable;
                } else {
                    span.finish();
                }
                throw throwable;
            }
        }
        if (httpRequest.isAsyncStarted()) {
            httpRequest.getAsyncContext().addListener(new /* invalid duplicate definition of identical inner class */);
            return;
        } else {
            span.finish();
        }
        return;
    }

    public void destroy() {
        this.filterConfig = null;
    }

    protected boolean isTraced(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (this.skipPattern != null) {
            int contextLength = httpServletRequest.getContextPath() == null ? 0 : httpServletRequest.getContextPath().length();
            String url = httpServletRequest.getRequestURI().substring(contextLength);
            return !this.skipPattern.matcher(url).matches();
        }
        return true;
    }

    public static SpanContext serverSpanContext(ServletRequest servletRequest) {
        return (SpanContext)servletRequest.getAttribute(SERVER_SPAN_CONTEXT);
    }
}

