/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.outbound.transmission;

import com.google.inject.Inject;
import io.opentracing.Span;
import io.opentracing.Tracer;
import network.oxalis.api.error.ErrorTracker;
import network.oxalis.api.lang.OxalisTransmissionException;
import network.oxalis.api.lookup.LookupService;
import network.oxalis.api.model.Direction;
import network.oxalis.api.outbound.MessageSender;
import network.oxalis.api.outbound.TransmissionMessage;
import network.oxalis.api.outbound.TransmissionRequest;
import network.oxalis.api.outbound.TransmissionResponse;
import network.oxalis.api.outbound.Transmitter;
import network.oxalis.api.statistics.StatisticsService;
import network.oxalis.api.transmission.TransmissionVerifier;
import network.oxalis.commons.mode.OxalisCertificateValidator;
import network.oxalis.commons.tracing.Traceable;
import network.oxalis.outbound.transmission.DefaultTransmissionRequest;
import network.oxalis.outbound.transmission.MessageSenderFactory;
import network.oxalis.vefa.peppol.common.code.Service;
import network.oxalis.vefa.peppol.common.model.Endpoint;
import network.oxalis.vefa.peppol.common.model.TransportProfile;
import network.oxalis.vefa.peppol.security.lang.PeppolSecurityException;

class DefaultTransmitter
extends Traceable
implements Transmitter {
    private final MessageSenderFactory messageSenderFactory;
    private final StatisticsService statisticsService;
    private final TransmissionVerifier transmissionVerifier;
    private final LookupService lookupService;
    private final OxalisCertificateValidator certificateValidator;
    private final ErrorTracker errorTracker;

    @Inject
    public DefaultTransmitter(MessageSenderFactory messageSenderFactory, StatisticsService statisticsService, TransmissionVerifier transmissionVerifier, LookupService lookupService, Tracer tracer, OxalisCertificateValidator certificateValidator, ErrorTracker errorTracker) {
        super(tracer);
        this.messageSenderFactory = messageSenderFactory;
        this.statisticsService = statisticsService;
        this.transmissionVerifier = transmissionVerifier;
        this.lookupService = lookupService;
        this.certificateValidator = certificateValidator;
        this.errorTracker = errorTracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransmissionResponse transmit(TransmissionMessage transmissionMessage, Span root) throws OxalisTransmissionException {
        Span span = this.tracer.buildSpan("transmit").asChildOf(root).start();
        try {
            TransmissionResponse transmissionResponse = this.perform(transmissionMessage, span);
            return transmissionResponse;
        }
        finally {
            span.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransmissionResponse transmit(TransmissionMessage transmissionMessage) throws OxalisTransmissionException {
        Span root = this.tracer.buildSpan("transmit").start();
        try {
            TransmissionResponse transmissionResponse = this.perform(transmissionMessage, root);
            return transmissionResponse;
        }
        finally {
            root.finish();
        }
    }

    private TransmissionResponse perform(TransmissionMessage transmissionMessage, Span root) throws OxalisTransmissionException {
        try {
            TransmissionResponse transmissionResponse;
            Span span;
            TransmissionRequest transmissionRequest;
            if (transmissionMessage == null) {
                throw new OxalisTransmissionException("No transmission is provided.");
            }
            this.transmissionVerifier.verify(transmissionMessage.getHeader(), Direction.OUT);
            if (transmissionMessage instanceof TransmissionRequest) {
                transmissionRequest = (TransmissionRequest)transmissionMessage;
                if (transmissionRequest.getEndpoint().getCertificate() == null) {
                    throw new OxalisTransmissionException("Certificate of receiving access point is not provided.");
                }
                this.certificateValidator.validate(Service.AP, transmissionRequest.getEndpoint().getCertificate(), root);
            } else {
                span = this.tracer.buildSpan("Fetch endpoint information").asChildOf(root).start();
                try {
                    Endpoint endpoint = this.lookupService.lookup(transmissionMessage.getHeader(), span);
                    span.setTag("transport profile", endpoint.getTransportProfile().getIdentifier());
                    transmissionRequest = new DefaultTransmissionRequest(transmissionMessage, endpoint);
                }
                catch (OxalisTransmissionException e) {
                    span.setTag("exception", e.getMessage());
                    throw e;
                }
                finally {
                    span.finish();
                }
            }
            span = this.tracer.buildSpan("send message").asChildOf(root).start();
            try {
                TransportProfile transportProfile = transmissionRequest.getEndpoint().getTransportProfile();
                MessageSender messageSender = this.messageSenderFactory.getMessageSender(transportProfile);
                transmissionResponse = messageSender.send(transmissionRequest, span);
            }
            catch (OxalisTransmissionException e) {
                span.setTag("exception", e.getMessage());
                throw e;
            }
            finally {
                span.finish();
            }
            this.statisticsService.persist(transmissionRequest, transmissionResponse, root);
            return transmissionResponse;
        }
        catch (PeppolSecurityException e) {
            this.errorTracker.track(Direction.OUT, e, true);
            throw new OxalisTransmissionException("Unable to verify certificate of receiving access point.", (Throwable)e);
        }
        catch (OxalisTransmissionException e) {
            this.errorTracker.track(Direction.OUT, e, true);
            throw e;
        }
        catch (RuntimeException e) {
            this.errorTracker.track(Direction.OUT, e, false);
            throw e;
        }
    }
}

