/*
 * Decompiled with CFR 0.152.
 */
package brave.opentracing;

import brave.Span;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import io.opentracing.propagation.TextMapExtract;
import io.opentracing.propagation.TextMapInject;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

final class TextMapPropagation {
    static final Propagation.Setter<TextMapInject, String> SETTER = new Propagation.Setter<TextMapInject, String>(){

        @Override
        public void put(TextMapInject request, String key, String value) {
            request.put(key, value);
        }

        public String toString() {
            return "TextMapInject::put";
        }
    };
    static final Propagation.Getter<Map<String, String>, String> GETTER = new Propagation.Getter<Map<String, String>, String>(){

        @Override
        public String get(Map<String, String> carrier, String key) {
            return carrier.get(key.toLowerCase(Locale.ROOT));
        }

        public String toString() {
            return "Map::getLowerCase";
        }
    };

    TextMapPropagation() {
    }

    static final class TextMapExtractor
    implements TraceContext.Extractor<TextMapExtract> {
        final Set<String> allNames;
        final TraceContext.Extractor<Map<String, String>> delegate;

        TextMapExtractor(Propagation<String> propagation, Set<String> allNames, Propagation.Getter<Map<String, String>, String> getter) {
            this.allNames = allNames;
            this.delegate = propagation.extractor(getter);
        }

        @Override
        public TraceContextOrSamplingFlags extract(TextMapExtract entries) {
            LinkedHashMap<String, String> cache = new LinkedHashMap<String, String>();
            for (Map.Entry<String, String> next : entries) {
                String inputKey = next.getKey().toLowerCase(Locale.ROOT);
                if (!this.allNames.contains(inputKey)) continue;
                cache.put(inputKey, next.getValue());
            }
            return this.delegate.extract(cache);
        }
    }

    static enum REMOTE_SETTER implements Propagation.RemoteSetter<TextMapInject>
    {
        CLIENT{

            @Override
            public Span.Kind spanKind() {
                return Span.Kind.CLIENT;
            }
        }
        ,
        PRODUCER{

            @Override
            public Span.Kind spanKind() {
                return Span.Kind.PRODUCER;
            }
        }
        ,
        CONSUMER{

            @Override
            public Span.Kind spanKind() {
                return Span.Kind.CONSUMER;
            }
        };


        @Override
        public void put(TextMapInject request, String key, String value) {
            SETTER.put(request, key, value);
        }

        public String toString() {
            return SETTER.toString();
        }
    }
}

