/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.lookup.fetcher;

import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.List;
import network.oxalis.vefa.peppol.lookup.api.FetcherResponse;
import network.oxalis.vefa.peppol.lookup.api.LookupException;
import network.oxalis.vefa.peppol.lookup.fetcher.BasicApacheFetcher;
import network.oxalis.vefa.peppol.mode.Mode;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class ApacheFetcher
extends BasicApacheFetcher {
    private final PoolingHttpClientConnectionManager httpClientConnectionManager = new PoolingHttpClientConnectionManager();

    public ApacheFetcher(Mode mode) {
        super(mode);
    }

    protected CloseableHttpClient createClient() {
        return HttpClients.custom().setDefaultRequestConfig(this.requestConfig).setConnectionManager(this.httpClientConnectionManager).setConnectionManagerShared(true).build();
    }

    @Override
    public FetcherResponse fetch(List<URI> uriList) throws LookupException, FileNotFoundException {
        FetcherResponse fetcherResponse = null;
        Exception exceptionObj = null;
        if (uriList == null) {
            throw new LookupException("Unable to lookup requested url");
        }
        for (URI uri : uriList) {
            try {
                fetcherResponse = this.fetchResponseFromValidUri(uri);
                if (fetcherResponse == null) continue;
                exceptionObj = null;
                break;
            }
            catch (FileNotFoundException e) {
                exceptionObj = e;
            }
            catch (LookupException e) {
                exceptionObj = e;
            }
        }
        if (exceptionObj instanceof FileNotFoundException) {
            throw new FileNotFoundException();
        }
        if (exceptionObj instanceof LookupException) {
            throw new LookupException(exceptionObj.getMessage(), exceptionObj);
        }
        return fetcherResponse;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private FetcherResponse fetchResponseFromValidUri(URI uri) throws LookupException, FileNotFoundException {
        try (CloseableHttpClient httpClient = this.createClient();){
            HttpGet httpGet = new HttpGet(uri);
            try (CloseableHttpResponse response = httpClient.execute(httpGet);){
                switch (response.getStatusLine().getStatusCode()) {
                    case 200: {
                        FetcherResponse fetcherResponse = new FetcherResponse(new ByteArrayInputStream(ByteStreams.toByteArray(response.getEntity().getContent())), response.containsHeader("X-SMP-Namespace") ? response.getFirstHeader("X-SMP-Namespace").getValue() : null);
                        return fetcherResponse;
                    }
                    case 404: {
                        throw new FileNotFoundException(uri.toString());
                    }
                }
                throw new LookupException(String.format("Received code %s for lookup. URI: %s", response.getStatusLine().getStatusCode(), uri));
            }
        }
        catch (SocketException | SocketTimeoutException | UnknownHostException e) {
            throw new LookupException(String.format("Unable to fetch '%s'", uri), e);
        }
        catch (FileNotFoundException | LookupException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LookupException(e.getMessage(), e);
        }
    }
}

