/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.mode;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import network.oxalis.vefa.peppol.common.lang.PeppolLoadingException;

public class Mode {
    public static final String PRODUCTION = "PRODUCTION";
    public static final String TEST = "TEST";
    public static final String FRTEST = "FRTEST";
    private Config config;
    private String identifier;

    public static Mode of(String identifier) {
        return Mode.of(ConfigFactory.empty(), identifier);
    }

    public static Mode of(Config config, String identifier) {
        Config referenceConfig = ConfigFactory.defaultReference();
        Config result = ConfigFactory.systemProperties().withFallback(config).withFallback(referenceConfig);
        if (identifier != null && referenceConfig.hasPath(String.format("mode.%s", identifier))) {
            result = result.withFallback(referenceConfig.getConfig(String.format("mode.%s", identifier)));
        }
        if (result.hasPath("inherit")) {
            result = result.withFallback(referenceConfig.getConfig(String.format("mode.%s", result.getString("inherit"))));
        }
        if (referenceConfig.hasPath("mode.default")) {
            result = result.withFallback(referenceConfig.getConfig("mode.default"));
        }
        return new Mode(result, identifier);
    }

    private Mode(Config config, String identifier) {
        this.config = config;
        this.identifier = identifier;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public boolean hasString(String key) {
        return this.config.hasPath(key);
    }

    public String getString(String key) {
        return this.config.getString(key);
    }

    public Config getConfig() {
        return this.config;
    }

    public <T> T initiate(String key, Class<T> type, Map<String, Object> objectStorage) throws PeppolLoadingException {
        try {
            return (T)this.initiate(Class.forName(this.getString(key)), objectStorage);
        }
        catch (ClassNotFoundException e) {
            throw new PeppolLoadingException(String.format("Unable to initiate '%s'", this.getString(key)), e);
        }
    }

    public <T> T initiate(String key, Class<T> type) throws PeppolLoadingException {
        return this.initiate(key, type, null);
    }

    public <T> T initiate(Class<T> cls) throws PeppolLoadingException {
        return this.initiate(cls, null);
    }

    public <T> T initiate(Class<T> cls, Map<String, Object> objectStorage) throws PeppolLoadingException {
        try {
            try {
                return cls.getConstructor(Mode.class, Map.class).newInstance(this, objectStorage);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    return cls.getConstructor(Mode.class).newInstance(this);
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    return cls.newInstance();
                }
            }
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new PeppolLoadingException(String.format("Unable to initiate '%s'", cls), e);
        }
    }
}

