/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.utils;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class base32 {
    private final String alphabet;
    private final boolean padding;
    private final boolean lowercase;

    public base32(String alphabet, boolean padding, boolean lowercase) {
        this.alphabet = alphabet;
        this.padding = padding;
        this.lowercase = lowercase;
    }

    private static int blockLenToPadding(int blocklen) {
        switch (blocklen) {
            case 1: {
                return 6;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 0;
            }
        }
        return -1;
    }

    private static int paddingToBlockLen(int padlen) {
        switch (padlen) {
            case 6: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 1: {
                return 4;
            }
            case 0: {
                return 5;
            }
        }
        return -1;
    }

    public String toString(byte[] b) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        for (int i = 0; i < (b.length + 4) / 5; ++i) {
            int j;
            short[] s2 = new short[5];
            int[] t2 = new int[8];
            int blocklen = 5;
            for (int j2 = 0; j2 < 5; ++j2) {
                if (i * 5 + j2 < b.length) {
                    s2[j2] = (short)(b[i * 5 + j2] & 0xFF);
                    continue;
                }
                s2[j2] = 0;
                --blocklen;
            }
            int padlen = base32.blockLenToPadding(blocklen);
            t2[0] = (byte)(s2[0] >> 3 & 0x1F);
            t2[1] = (byte)((s2[0] & 7) << 2 | s2[1] >> 6 & 3);
            t2[2] = (byte)(s2[1] >> 1 & 0x1F);
            t2[3] = (byte)((s2[1] & 1) << 4 | s2[2] >> 4 & 0xF);
            t2[4] = (byte)((s2[2] & 0xF) << 1 | s2[3] >> 7 & 1);
            t2[5] = (byte)(s2[3] >> 2 & 0x1F);
            t2[6] = (byte)((s2[3] & 3) << 3 | s2[4] >> 5 & 7);
            t2[7] = (byte)(s2[4] & 0x1F);
            for (j = 0; j < t2.length - padlen; ++j) {
                char c = this.alphabet.charAt(t2[j]);
                if (this.lowercase) {
                    c = Character.toLowerCase(c);
                }
                os.write(c);
            }
            if (!this.padding) continue;
            for (j = t2.length - padlen; j < t2.length; ++j) {
                os.write(61);
            }
        }
        return new String(os.toByteArray());
    }

    public byte[] fromString(String str) {
        byte[] raw;
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        for (byte b : raw = str.getBytes()) {
            char c = (char)b;
            if (Character.isWhitespace(c)) continue;
            c = Character.toUpperCase(c);
            bs.write((byte)c);
        }
        if (this.padding) {
            if (bs.size() % 8 != 0) {
                return null;
            }
        } else {
            while (bs.size() % 8 != 0) {
                bs.write(61);
            }
        }
        byte[] in = bs.toByteArray();
        bs.reset();
        DataOutputStream ds = new DataOutputStream(bs);
        for (int i = 0; i < in.length / 8; ++i) {
            char c;
            short[] s2 = new short[8];
            int[] t2 = new int[5];
            int padlen = 8;
            for (int j = 0; j < 8 && (c = (char)in[i * 8 + j]) != '='; ++j) {
                s2[j] = (short)this.alphabet.indexOf(in[i * 8 + j]);
                if (s2[j] < 0) {
                    return null;
                }
                --padlen;
            }
            int blocklen = base32.paddingToBlockLen(padlen);
            if (blocklen < 0) {
                return null;
            }
            t2[0] = s2[0] << 3 | s2[1] >> 2;
            t2[1] = (s2[1] & 3) << 6 | s2[2] << 1 | s2[3] >> 4;
            t2[2] = (s2[3] & 0xF) << 4 | s2[4] >> 1 & 0xF;
            t2[3] = s2[4] << 7 | s2[5] << 2 | s2[6] >> 3;
            t2[4] = (s2[6] & 7) << 5 | s2[7];
            try {
                for (int j = 0; j < blocklen; ++j) {
                    ds.writeByte((byte)(t2[j] & 0xFF));
                }
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return bs.toByteArray();
    }

    public static class Alphabet {
        public static final String BASE32 = "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567=";
        public static final String BASE32HEX = "0123456789ABCDEFGHIJKLMNOPQRSTUV=";

        private Alphabet() {
        }
    }
}

