/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.security.util;

import java.io.IOException;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.Map;
import network.oxalis.commons.certvalidator.ValidatorGroup;
import network.oxalis.commons.certvalidator.ValidatorLoader;
import network.oxalis.commons.certvalidator.api.CertificateValidationException;
import network.oxalis.commons.certvalidator.lang.ValidatorParsingException;
import network.oxalis.vefa.peppol.common.code.Service;
import network.oxalis.vefa.peppol.common.lang.PeppolLoadingException;
import network.oxalis.vefa.peppol.mode.Mode;
import network.oxalis.vefa.peppol.security.api.CertificateValidator;
import network.oxalis.vefa.peppol.security.lang.PeppolSecurityException;

public class DifiCertificateValidator
implements CertificateValidator {
    private ValidatorGroup validator;
    private Mode mode;

    public DifiCertificateValidator(Mode mode) throws PeppolLoadingException {
        this(mode, null);
    }

    public DifiCertificateValidator(Mode mode, Map<String, Object> objectStorage) throws PeppolLoadingException {
        this.mode = mode;
        try (InputStream inputStream = this.getClass().getResourceAsStream(mode.getString("security.pki"));){
            this.validator = ValidatorLoader.newInstance().putAll(objectStorage).build(inputStream);
        }
        catch (IOException | ValidatorParsingException e) {
            throw new PeppolLoadingException("Unable to initiate PKI.", e);
        }
    }

    @Override
    public void validate(Service service, X509Certificate certificate) throws PeppolSecurityException {
        try {
            this.validator.validate(this.mode.getString(String.format("security.validator.%s", service.toString())), certificate);
        }
        catch (CertificateValidationException e) {
            throw new PeppolSecurityException(e.getMessage(), e);
        }
    }
}

