/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.commons.mode;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import io.opentracing.contrib.apache.http.client.Constants;
import io.opentracing.contrib.spanmanager.DefaultSpanManager;
import io.opentracing.contrib.spanmanager.SpanManager;
import java.io.IOException;
import java.net.URI;
import java.security.cert.CRLException;
import java.security.cert.X509CRL;
import javax.inject.Named;
import network.oxalis.commons.certvalidator.api.CertificateValidationException;
import network.oxalis.commons.certvalidator.api.CrlCache;
import network.oxalis.commons.certvalidator.util.CrlUtils;
import network.oxalis.commons.certvalidator.util.SimpleCachingCrlFetcher;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.BasicHttpContext;

@Singleton
public class OxalisCrlFetcher
extends SimpleCachingCrlFetcher {
    @Inject
    private Provider<CloseableHttpClient> httpClientProvider;
    @Inject
    @Named(value="certificate")
    private RequestConfig requestConfig;

    @Inject
    public OxalisCrlFetcher(CrlCache crlCache) {
        super(crlCache);
    }

    @Override
    protected X509CRL httpDownload(String url) throws CertificateValidationException {
        X509CRL x509CRL;
        block9: {
            SpanManager.ManagedSpan span = DefaultSpanManager.getInstance().current();
            BasicHttpContext basicHttpContext = new BasicHttpContext();
            if (span.getSpan() != null) {
                basicHttpContext.setAttribute(Constants.PARENT_CONTEXT, span.getSpan().context());
            }
            HttpGet httpGet = new HttpGet(URI.create(url));
            httpGet.setConfig(this.requestConfig);
            CloseableHttpResponse response = this.httpClientProvider.get().execute((HttpUriRequest)httpGet, basicHttpContext);
            try {
                X509CRL crl = CrlUtils.load(response.getEntity().getContent());
                this.crlCache.set(url, crl);
                x509CRL = crl;
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | CRLException e) {
                    throw new CertificateValidationException(String.format("Failed to download CRL '%s' (%s)", url, e.getMessage()), e);
                }
            }
            response.close();
        }
        return x509CRL;
    }
}

