/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.xbill.DNS.DClass;
import org.xbill.DNS.Name;
import org.xbill.DNS.RRSIGRecord;
import org.xbill.DNS.Record;
import org.xbill.DNS.Type;

public class RRset
implements Serializable {
    private final ArrayList<Record> rrs;
    private final ArrayList<RRSIGRecord> sigs;
    private short position;
    private long ttl;

    public RRset() {
        this.rrs = new ArrayList(1);
        this.sigs = new ArrayList(0);
    }

    public RRset(Record record) {
        this();
        this.addRR(record);
    }

    public RRset(Record ... records) {
        this();
        Objects.requireNonNull(records);
        for (Record r : records) {
            this.addRR(r);
        }
    }

    public RRset(RRset rrset) {
        this.rrs = new ArrayList<Record>(rrset.rrs);
        this.sigs = new ArrayList<RRSIGRecord>(rrset.sigs);
        this.position = rrset.position;
        this.ttl = rrset.ttl;
    }

    public void addRR(RRSIGRecord r) {
        this.addRR(r, this.sigs);
    }

    public void addRR(Record r) {
        if (r instanceof RRSIGRecord) {
            this.addRR((RRSIGRecord)r, this.sigs);
            return;
        }
        this.addRR(r, this.rrs);
    }

    private <X extends Record> void addRR(X r, List<X> rs) {
        if (this.sigs.isEmpty() && this.rrs.isEmpty()) {
            rs.add(r);
            this.ttl = r.getTTL();
            return;
        }
        this.checkSameRRset(r, this.rrs);
        this.checkSameRRset(r, this.sigs);
        Object copy = r;
        if (((Record)copy).getTTL() > this.ttl) {
            copy = r.cloneRecord();
            ((Record)copy).setTTL(this.ttl);
        } else if (((Record)copy).getTTL() < this.ttl) {
            this.ttl = ((Record)copy).getTTL();
            this.adjustTtl(((Record)copy).getTTL(), this.rrs);
            this.adjustTtl(((Record)copy).getTTL(), this.sigs);
        }
        if (!rs.contains(copy)) {
            rs.add(copy);
        }
    }

    private <X extends Record> void adjustTtl(long ttl, List<X> rs) {
        for (int i = 0; i < rs.size(); ++i) {
            Record tmp = ((Record)rs.get(i)).cloneRecord();
            tmp.setTTL(ttl);
            rs.set(i, tmp);
        }
    }

    private void checkSameRRset(Record r, List<? extends Record> rs) {
        if (rs.isEmpty()) {
            return;
        }
        if (!r.sameRRset(rs.get(0))) {
            throw new IllegalArgumentException("record does not match rrset");
        }
    }

    public void deleteRR(RRSIGRecord r) {
        this.sigs.remove(r);
    }

    public void deleteRR(Record r) {
        if (r instanceof RRSIGRecord) {
            this.sigs.remove(r);
            return;
        }
        this.rrs.remove(r);
    }

    public void clear() {
        this.rrs.clear();
        this.sigs.clear();
    }

    public List<Record> rrs(boolean cycle) {
        if (!cycle || this.rrs.size() <= 1) {
            return Collections.unmodifiableList(this.rrs);
        }
        ArrayList<Record> l = new ArrayList<Record>(this.rrs.size());
        if (this.position == Short.MAX_VALUE) {
            this.position = 0;
        }
        short s2 = this.position;
        this.position = (short)(s2 + 1);
        int start = s2 % this.rrs.size();
        l.addAll(this.rrs.subList(start, this.rrs.size()));
        l.addAll(this.rrs.subList(0, start));
        return l;
    }

    public List<Record> rrs() {
        return this.rrs(true);
    }

    public List<RRSIGRecord> sigs() {
        return Collections.unmodifiableList(this.sigs);
    }

    public int size() {
        return this.rrs.size();
    }

    public Name getName() {
        return this.first().getName();
    }

    public int getType() {
        return this.first().getRRsetType();
    }

    public int getDClass() {
        return this.first().getDClass();
    }

    public long getTTL() {
        return this.first().getTTL();
    }

    public Record first() {
        if (!this.rrs.isEmpty()) {
            return this.rrs.get(0);
        }
        if (!this.sigs.isEmpty()) {
            return this.sigs.get(0);
        }
        throw new IllegalStateException("rrset is empty");
    }

    private void appendRrList(Iterator<? extends Record> it, StringBuilder sb) {
        while (it.hasNext()) {
            Record rr = it.next();
            sb.append("[");
            sb.append(rr.rdataToString());
            sb.append("]");
            if (!it.hasNext()) continue;
            sb.append(" ");
        }
    }

    public String toString() {
        if (this.rrs.isEmpty() && this.sigs.isEmpty()) {
            return "{empty}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{ ");
        sb.append(this.getName()).append(" ");
        sb.append(this.getTTL()).append(" ");
        sb.append(DClass.string(this.getDClass())).append(" ");
        sb.append(Type.string(this.getType())).append(" ");
        this.appendRrList(this.rrs.iterator(), sb);
        if (!this.sigs.isEmpty()) {
            sb.append(" sigs: ");
            this.appendRrList(this.sigs.iterator(), sb);
        }
        sb.append(" }");
        return sb.toString();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RRset)) {
            return false;
        }
        RRset other = (RRset)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ArrayList<Record> this$rrs = this.rrs;
        ArrayList<Record> other$rrs = other.rrs;
        if (this$rrs == null ? other$rrs != null : !((Object)this$rrs).equals(other$rrs)) {
            return false;
        }
        ArrayList<RRSIGRecord> this$sigs = this.sigs;
        ArrayList<RRSIGRecord> other$sigs = other.sigs;
        return !(this$sigs == null ? other$sigs != null : !((Object)this$sigs).equals(other$sigs));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RRset;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ArrayList<Record> $rrs = this.rrs;
        result = result * 59 + ($rrs == null ? 43 : ((Object)$rrs).hashCode());
        ArrayList<RRSIGRecord> $sigs = this.sigs;
        result = result * 59 + ($sigs == null ? 43 : ((Object)$sigs).hashCode());
        return result;
    }
}

