/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.lookup.util;

import com.google.common.io.BaseEncoding;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.Security;
import network.oxalis.vefa.peppol.common.model.ParticipantIdentifier;
import network.oxalis.vefa.peppol.lookup.api.LookupException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class DynamicHostnameGenerator {
    private BaseEncoding encoding;
    private String prefix;
    private String hostname;
    private String digestAlgorithm;

    public DynamicHostnameGenerator(String prefix, String hostname, String digestAlgorithm) {
        this(prefix, hostname, digestAlgorithm, BaseEncoding.base16());
    }

    public DynamicHostnameGenerator(String prefix, String hostname, String digestAlgorithm, BaseEncoding encoding) {
        this.prefix = prefix;
        this.hostname = hostname;
        this.digestAlgorithm = digestAlgorithm;
        this.encoding = encoding;
    }

    public String generate(ParticipantIdentifier participantIdentifier) throws LookupException {
        String receiverHash;
        try {
            MessageDigest md = MessageDigest.getInstance(this.digestAlgorithm, "BC");
            byte[] digest = md.digest(participantIdentifier.getIdentifier().getBytes(StandardCharsets.UTF_8));
            receiverHash = this.encoding.encode(digest).toLowerCase();
        }
        catch (Exception e) {
            throw new LookupException(e.getMessage(), e);
        }
        return String.format("%s%s.%s.%s", this.prefix, receiverHash, participantIdentifier.getScheme().getIdentifier(), this.hostname);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
    }
}

