/*
 * Decompiled with CFR 0.152.
 */
package eu.sendregning.oxalis;

import eu.sendregning.oxalis.TransmissionParameters;
import eu.sendregning.oxalis.TransmissionResult;
import io.opentracing.Span;
import io.opentracing.Tracer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import network.oxalis.api.evidence.EvidenceFactory;
import network.oxalis.api.lang.EvidenceException;
import network.oxalis.api.lang.OxalisTransmissionException;
import network.oxalis.api.outbound.TransmissionRequest;
import network.oxalis.api.outbound.TransmissionResponse;
import network.oxalis.api.outbound.Transmitter;
import network.oxalis.commons.filesystem.FileUtils;
import network.oxalis.outbound.transmission.TransmissionRequestBuilder;
import network.oxalis.vefa.peppol.common.model.Endpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransmissionTask
implements Callable<TransmissionResult> {
    private static final Logger log = LoggerFactory.getLogger(TransmissionTask.class);
    private final TransmissionParameters params;
    private final File xmlPayloadFile;
    private final EvidenceFactory evidenceFactory;
    private final Tracer tracer;

    public TransmissionTask(TransmissionParameters params, File xmlPayloadFile) {
        this.params = params;
        this.xmlPayloadFile = xmlPayloadFile;
        this.evidenceFactory = params.getOxalisOutboundComponent().getEvidenceFactory();
        this.tracer = params.getOxalisOutboundComponent().getInjector().getInstance(Tracer.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransmissionResult call() throws Exception {
        Span span = this.tracer.buildSpan("standalone").start();
        try {
            Transmitter transmitter;
            long duration = 0L;
            if (this.params.isUseFactory()) {
                try (InputStream inputStream = Files.newInputStream(this.xmlPayloadFile.toPath(), new OpenOption[0]);){
                    TransmissionResponse transmissionResponse = this.params.getOxalisOutboundComponent().getTransmissionService().send(inputStream, this.params.getTag(), span);
                }
            }
            TransmissionRequest transmissionRequest = this.createTransmissionRequest(span);
            Span span1 = this.tracer.buildSpan("get transmitter").asChildOf(span).start();
            try {
                transmitter = this.params.getOxalisOutboundComponent().getTransmitter();
            }
            finally {
                span1.finish();
            }
            long start = System.nanoTime();
            TransmissionResponse transmissionResponse = this.performTransmission(this.params.getEvidencePath(), transmitter, transmissionRequest, span);
            long elapsed = System.nanoTime() - start;
            duration = TimeUnit.MILLISECONDS.convert(elapsed, TimeUnit.NANOSECONDS);
            TransmissionResult transmissionResult = new TransmissionResult(duration, transmissionResponse.getTransmissionIdentifier());
            return transmissionResult;
            TransmissionResult transmissionResult2 = new TransmissionResult(duration, transmissionResponse.getTransmissionIdentifier());
            return transmissionResult2;
        }
        finally {
            span.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TransmissionRequest createTransmissionRequest(Span root) {
        Span span = this.tracer.buildSpan("create transmission request").asChildOf(root).start();
        try {
            TransmissionRequestBuilder requestBuilder = this.params.getOxalisOutboundComponent().getTransmissionRequestBuilder();
            requestBuilder.setTransmissionBuilderOverride(true);
            if (this.params.getReceiver().isPresent()) {
                requestBuilder.receiver(this.params.getReceiver().get());
            }
            if (this.params.getSender().isPresent()) {
                requestBuilder.sender(this.params.getSender().get());
            }
            if (this.params.getDocType().isPresent()) {
                requestBuilder.documentType(this.params.getDocType().get());
            }
            if (this.params.getProcessIdentifier().isPresent()) {
                requestBuilder.processType(this.params.getProcessIdentifier().get());
            }
            try (FileInputStream inputStream = new FileInputStream(this.xmlPayloadFile);){
                requestBuilder.payLoad(inputStream);
            }
            if (this.params.getEndpoint().isPresent()) {
                Endpoint endpoint = this.params.getEndpoint().get();
                requestBuilder.overrideAs2Endpoint(endpoint);
            }
            TransmissionRequest transmissionRequest = requestBuilder.build(span);
            return transmissionRequest;
        }
        catch (Exception e) {
            span.setTag("exception", String.valueOf(e.getMessage()));
            System.out.println();
            System.out.println("Message failed : " + e.getMessage());
            System.out.println();
            TransmissionRequest transmissionRequest = null;
            return transmissionRequest;
        }
        finally {
            span.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TransmissionResponse performTransmission(File evidencePath, Transmitter transmitter, TransmissionRequest transmissionRequest, Span root) throws OxalisTransmissionException, EvidenceException, IOException {
        Span span = this.tracer.buildSpan("transmission").asChildOf(root).start();
        try {
            long start = System.nanoTime();
            TransmissionResponse transmissionResponse = transmitter.transmit(transmissionRequest, span);
            long elapsed = System.nanoTime() - start;
            long durartionInMs = TimeUnit.MILLISECONDS.convert(elapsed, TimeUnit.NANOSECONDS);
            log.debug(String.format("Message using messageId %s sent to %s using %s was assigned transmissionId %s took %dms\n", transmissionResponse.getHeader().getIdentifier().getIdentifier(), transmissionResponse.getEndpoint().getAddress(), transmissionResponse.getProtocol().getIdentifier(), transmissionResponse.getTransmissionIdentifier(), durartionInMs));
            this.saveEvidence(transmissionResponse, evidencePath, span);
            TransmissionResponse transmissionResponse2 = transmissionResponse;
            return transmissionResponse2;
        }
        finally {
            span.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveEvidence(TransmissionResponse transmissionResponse, File evidencePath, Span root) throws IOException, EvidenceException {
        Span span = this.tracer.buildSpan("save evidence").asChildOf(root).start();
        String transIdent = FileUtils.filterString(transmissionResponse.getTransmissionIdentifier().toString());
        File evidenceFile = new File(evidencePath, transIdent + ".receipt.dat");
        try (OutputStream outputStream = Files.newOutputStream(evidenceFile.toPath(), new OpenOption[0]);){
            this.evidenceFactory.write(outputStream, transmissionResponse);
        }
        finally {
            span.finish();
        }
    }
}

