/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.commons.http;

import com.google.inject.Provides;
import com.google.inject.Singleton;
import io.opentracing.Tracer;
import io.opentracing.contrib.apache.http.client.TracingHttpClientBuilder;
import java.util.concurrent.TimeUnit;
import network.oxalis.api.settings.Settings;
import network.oxalis.commons.guice.OxalisModule;
import network.oxalis.commons.http.HttpConf;
import network.oxalis.commons.util.OxalisVersion;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class ApacheHttpModule
extends OxalisModule {
    private static final String USER_AGENT = String.format("Oxalis %s", OxalisVersion.getVersion());

    @Override
    protected void configure() {
        this.bindSettings(HttpConf.class);
    }

    @Provides
    @Singleton
    protected PoolingHttpClientConnectionManager getPoolingHttpClientConnectionManager(Settings<HttpConf> settings) {
        PoolingHttpClientConnectionManager httpClientConnectionManager = new PoolingHttpClientConnectionManager(settings.getInt(HttpConf.POOL_TIME_TO_LIVE), TimeUnit.SECONDS);
        httpClientConnectionManager.setDefaultMaxPerRoute(settings.getInt(HttpConf.POOL_MAX_ROUTE));
        httpClientConnectionManager.setMaxTotal(settings.getInt(HttpConf.POOL_TOTAL));
        httpClientConnectionManager.setValidateAfterInactivity(settings.getInt(HttpConf.POOL_VALIDATE_AFTER_INACTIVITY));
        return httpClientConnectionManager;
    }

    @Provides
    @Singleton
    protected RequestConfig getRequestConfig(Settings<HttpConf> settings) {
        return RequestConfig.custom().setConnectTimeout(settings.getInt(HttpConf.TIMEOUT_CONNECT)).setConnectionRequestTimeout(settings.getInt(HttpConf.TIMEOUT_READ)).setSocketTimeout(settings.getInt(HttpConf.TIMEOUT_SOCKET)).build();
    }

    @Provides
    protected CloseableHttpClient getHttpClient(PoolingHttpClientConnectionManager connectionManager, RequestConfig requestConfig, Tracer tracer) {
        TracingHttpClientBuilder httpClientBuilder = new TracingHttpClientBuilder().withTracer(tracer);
        httpClientBuilder.setUserAgent(USER_AGENT);
        httpClientBuilder.setDefaultRequestConfig(requestConfig);
        httpClientBuilder.setConnectionManager(connectionManager);
        httpClientBuilder.setConnectionManagerShared(true);
        httpClientBuilder.useSystemProperties();
        return httpClientBuilder.build();
    }
}

