/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.commons.security;

import java.io.ByteArrayInputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;

public class CertificateUtils {
    private static final CertificateFactory CERTIFICATE_FACTORY;

    public static String extractCommonName(X509Certificate cert) {
        X500Principal principal = cert.getSubjectX500Principal();
        return CertificateUtils.extractCommonName(new X500Name(principal.getName()));
    }

    public static String extractCommonName(X500Name x500name) {
        RDN cn = x500name.getRDNs(BCStyle.CN)[0];
        return IETFUtils.valueToString(cn.getFirst().getValue());
    }

    public static boolean containsCommonName(X509Certificate cert, String commonName) {
        return commonName == null || commonName.trim().equalsIgnoreCase(CertificateUtils.extractCommonName(cert));
    }

    public static boolean containsCommonName(X500Name x500name, String commonName) {
        return commonName == null || commonName.trim().equalsIgnoreCase(CertificateUtils.extractCommonName(x500name));
    }

    public static X509Certificate parseCertificate(byte[] encoded) throws CertificateException {
        return (X509Certificate)CERTIFICATE_FACTORY.generateCertificate(new ByteArrayInputStream(encoded));
    }

    static {
        try {
            CERTIFICATE_FACTORY = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

