/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.tools;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.List;
import org.xbill.DNS.DClass;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.Rcode;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.SOARecord;
import org.xbill.DNS.Section;
import org.xbill.DNS.SimpleResolver;
import org.xbill.DNS.TTL;
import org.xbill.DNS.Tokenizer;
import org.xbill.DNS.Type;

public class update {
    Message query;
    Message response;
    Resolver res;
    String server;
    Name zone;
    long defaultTTL;
    int defaultClass;
    PrintStream log;

    void print(Object o) {
        System.out.println(o);
        if (this.log != null) {
            this.log.println(o);
        }
    }

    public Message newMessage() {
        Message msg = new Message();
        msg.getHeader().setOpcode(5);
        return msg;
    }

    /*
     * Exception decompiling
     */
    public update(InputStream in) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 63[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void sendUpdate() throws IOException {
        if (this.query.getHeader().getCount(2) == 0) {
            this.print("Empty update message.  Ignoring.");
            return;
        }
        if (this.query.getHeader().getCount(0) == 0) {
            Name updzone = this.zone;
            int dclass = this.defaultClass;
            if (updzone == null) {
                for (Record rec : this.query.getSection(2)) {
                    if (updzone == null) {
                        updzone = new Name(rec.getName(), 1);
                    }
                    if (rec.getDClass() == 254 || rec.getDClass() == 255) continue;
                    dclass = rec.getDClass();
                    break;
                }
            }
            Record soa = Record.newRecord(updzone, 6, dclass);
            this.query.addRecord(soa, 0);
        }
        if (this.res == null) {
            this.res = new SimpleResolver(this.server);
        }
        this.response = this.res.send(this.query);
        this.print(this.response);
    }

    Record parseRR(Tokenizer st, int classValue, long TTLValue) throws IOException {
        int type;
        long ttl;
        Name name = st.getName(this.zone);
        String s2 = st.getString();
        try {
            ttl = TTL.parseTTL(s2);
            s2 = st.getString();
        }
        catch (NumberFormatException e) {
            ttl = TTLValue;
        }
        if (DClass.value(s2) >= 0) {
            classValue = DClass.value(s2);
            s2 = st.getString();
        }
        if ((type = Type.value(s2)) < 0) {
            throw new IOException("Invalid type: " + s2);
        }
        return Record.fromString(name, type, classValue, ttl, st, this.zone);
    }

    void doRequire(Tokenizer st) throws IOException {
        Record record;
        Name name = st.getName(this.zone);
        Tokenizer.Token token = st.get();
        if (token.isString()) {
            int type = Type.value(token.value());
            if (type < 0) {
                throw new IOException("Invalid type: " + token.value());
            }
            token = st.get();
            boolean iseol = token.isEOL();
            st.unget();
            record = !iseol ? Record.fromString(name, type, this.defaultClass, 0L, st, this.zone) : Record.newRecord(name, type, 255, 0L);
        } else {
            record = Record.newRecord(name, 255, 255, 0L);
        }
        this.query.addRecord(record, 1);
        this.print(record);
    }

    void doProhibit(Tokenizer st) throws IOException {
        int type;
        Name name = st.getName(this.zone);
        Tokenizer.Token token = st.get();
        if (token.isString()) {
            type = Type.value(token.value());
            if (type < 0) {
                throw new IOException("Invalid type: " + token.value());
            }
        } else {
            type = 255;
        }
        Record record = Record.newRecord(name, type, 254, 0L);
        this.query.addRecord(record, 1);
        this.print(record);
    }

    void doAdd(Tokenizer st) throws IOException {
        Record record = this.parseRR(st, this.defaultClass, this.defaultTTL);
        this.query.addRecord(record, 2);
        this.print(record);
    }

    void doDelete(Tokenizer st) throws IOException {
        Record record;
        Name name = st.getName(this.zone);
        Tokenizer.Token token = st.get();
        if (token.isString()) {
            int type;
            String s2 = token.value();
            if (DClass.value(s2) >= 0) {
                s2 = st.getString();
            }
            if ((type = Type.value(s2)) < 0) {
                throw new IOException("Invalid type: " + s2);
            }
            token = st.get();
            boolean iseol = token.isEOL();
            st.unget();
            record = !iseol ? Record.fromString(name, type, 254, 0L, st, this.zone) : Record.newRecord(name, type, 255, 0L);
        } else {
            record = Record.newRecord(name, 255, 255, 0L);
        }
        this.query.addRecord(record, 2);
        this.print(record);
    }

    void doGlue(Tokenizer st) throws IOException {
        Record record = this.parseRR(st, this.defaultClass, this.defaultTTL);
        this.query.addRecord(record, 3);
        this.print(record);
    }

    void doQuery(Tokenizer st) throws IOException {
        int type = 1;
        int dclass = this.defaultClass;
        Name name = st.getName(this.zone);
        Tokenizer.Token token = st.get();
        if (token.isString()) {
            type = Type.value(token.value());
            if (type < 0) {
                throw new IOException("Invalid type");
            }
            token = st.get();
            if (token.isString() && (dclass = DClass.value(token.value())) < 0) {
                throw new IOException("Invalid class");
            }
        }
        Record rec = Record.newRecord(name, type, dclass);
        Message newQuery = Message.newQuery(rec);
        if (this.res == null) {
            this.res = new SimpleResolver(this.server);
        }
        this.response = this.res.send(newQuery);
        this.print(this.response);
    }

    void doFile(Tokenizer st, List<BufferedReader> inputs, List<InputStream> istreams) throws IOException {
        String s2 = st.getString();
        try {
            InputStream is = s2.equals("-") ? System.in : new FileInputStream(s2);
            istreams.add(0, is);
            inputs.add(0, new BufferedReader(new InputStreamReader(is)));
        }
        catch (FileNotFoundException e) {
            this.print(s2 + " not found");
        }
    }

    void doLog(Tokenizer st) throws IOException {
        String s2 = st.getString();
        try (FileOutputStream fos = new FileOutputStream(s2);){
            this.log = new PrintStream(fos);
        }
        catch (Exception e) {
            this.print("Error opening " + s2);
        }
    }

    boolean doAssert(Tokenizer st) throws IOException {
        String field = st.getString();
        String expected = st.getString();
        String value = null;
        boolean flag = true;
        if (this.response == null) {
            this.print("No response has been received");
            return true;
        }
        if (field.equalsIgnoreCase("rcode")) {
            int rcode = this.response.getHeader().getRcode();
            if (rcode != Rcode.value(expected)) {
                value = Rcode.string(rcode);
                flag = false;
            }
        } else if (field.equalsIgnoreCase("serial")) {
            List<Record> answers = this.response.getSection(1);
            if (answers.isEmpty() || !(answers.get(0) instanceof SOARecord)) {
                this.print("Invalid response (no SOA)");
            } else {
                SOARecord soa = (SOARecord)answers.get(0);
                long serial = soa.getSerial();
                if (serial != Long.parseLong(expected)) {
                    value = Long.toString(serial);
                    flag = false;
                }
            }
        } else if (field.equalsIgnoreCase("tsig")) {
            value = this.response.isSigned() ? (this.response.isVerified() ? "ok" : "failed") : "unsigned";
            if (!value.equalsIgnoreCase(expected)) {
                flag = false;
            }
        } else {
            int section = Section.value(field);
            if (section >= 0) {
                int count = this.response.getHeader().getCount(section);
                if (count != Integer.parseInt(expected)) {
                    value = Integer.toString(count);
                    flag = false;
                }
            } else {
                this.print("Invalid assertion keyword: " + field);
            }
        }
        if (!flag) {
            Tokenizer.Token token;
            this.print("Expected " + field + " " + expected + ", received " + value);
            while ((token = st.get()).isString()) {
                this.print(token.value());
            }
            st.unget();
        }
        return flag;
    }

    static void help(String topic) {
        System.out.println();
        if (topic == null) {
            System.out.println("The following are supported commands:\nadd      assert   class    clear    date     delete\necho     edns     file     glue     help     key\nlog      port     prohibit query    quit     require\nsend     server   show     sleep    tcp      ttl\nzone     #\n");
            return;
        }
        switch (topic = topic.toLowerCase()) {
            case "add": {
                System.out.println("add <name> [ttl] [class] <type> <data>\n\nspecify a record to be added\n");
                break;
            }
            case "assert": {
                System.out.println("assert <field> <value> [msg]\n\nasserts that the value of the field in the last\nresponse matches the value specified.  If not,\nthe message is printed (if present) and the\nprogram exits.  The field may be any of <rcode>,\n<serial>, <tsig>, <qu>, <an>, <au>, or <ad>.\n");
                break;
            }
            case "class": {
                System.out.println("class <class>\n\nclass of the zone to be updated (default: IN)\n");
                break;
            }
            case "clear": {
                System.out.println("clear\n\nclears the current update packet\n");
                break;
            }
            case "date": {
                System.out.println("date [-ms]\n\nprints the current date and time in human readable\nformat or as the number of milliseconds since the\nepoch");
                break;
            }
            case "delete": {
                System.out.println("delete <name> [ttl] [class] <type> <data> \ndelete <name> <type> \ndelete <name>\n\nspecify a record or set to be deleted, or that\nall records at a name should be deleted\n");
                break;
            }
            case "echo": {
                System.out.println("echo <text>\n\nprints the text\n");
                break;
            }
            case "edns": {
                System.out.println("edns <level>\n\nEDNS level specified when sending messages\n");
                break;
            }
            case "file": {
                System.out.println("file <file>\n\nopens the specified file as the new input source\n(- represents stdin)\n");
                break;
            }
            case "glue": {
                System.out.println("glue <name> [ttl] [class] <type> <data>\n\nspecify an additional record\n");
                break;
            }
            case "help": {
                System.out.println("help\nhelp [topic]\n\nprints a list of commands or help about a specific\ncommand\n");
                break;
            }
            case "key": {
                System.out.println("key <name> <data>\n\nTSIG key used to sign messages\n");
                break;
            }
            case "log": {
                System.out.println("log <file>\n\nopens the specified file and uses it to log output\n");
                break;
            }
            case "port": {
                System.out.println("port <port>\n\nUDP/TCP port messages are sent to (default: 53)\n");
                break;
            }
            case "prohibit": {
                System.out.println("prohibit <name> <type> \nprohibit <name>\n\nrequire that a set or name is not present\n");
                break;
            }
            case "query": {
                System.out.println("query <name> [type [class]] \n\nissues a query\n");
                break;
            }
            case "q": 
            case "quit": {
                System.out.println("quit\n\nquits the program\n");
                break;
            }
            case "require": {
                System.out.println("require <name> [ttl] [class] <type> <data> \nrequire <name> <type> \nrequire <name>\n\nrequire that a record, set, or name is present\n");
                break;
            }
            case "send": {
                System.out.println("send\n\nsends and resets the current update packet\n");
                break;
            }
            case "server": {
                System.out.println("server <name> [port]\n\nserver that receives send updates/queries\n");
                break;
            }
            case "show": {
                System.out.println("show\n\nshows the current update packet\n");
                break;
            }
            case "sleep": {
                System.out.println("sleep <milliseconds>\n\npause for interval before next command\n");
                break;
            }
            case "tcp": {
                System.out.println("tcp\n\nTCP should be used to send all messages\n");
                break;
            }
            case "ttl": {
                System.out.println("ttl <ttl>\n\ndefault ttl of added records (default: 0)\n");
                break;
            }
            case "zone": 
            case "origin": {
                System.out.println("zone <zone>\n\nzone to update (default: .\n");
                break;
            }
            case "#": {
                System.out.println("# <text>\n\na comment\n");
                break;
            }
            default: {
                System.out.println("Topic '" + topic + "' unrecognized\n");
            }
        }
    }

    public static void main(String[] args) {
        InputStream in = null;
        if (args.length >= 1) {
            try {
                in = new FileInputStream(args[0]);
            }
            catch (FileNotFoundException e) {
                System.out.println(args[0] + " not found.");
                System.exit(1);
            }
        } else {
            in = System.in;
        }
        new update(in);
    }
}

