/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.xbill.DNS.EDNSOption;
import org.xbill.DNS.Message;
import org.xbill.DNS.ResolverListener;
import org.xbill.DNS.TSIG;
import org.xbill.DNS.Type;

public interface Resolver {
    public void setPort(int var1);

    public void setTCP(boolean var1);

    public void setIgnoreTruncation(boolean var1);

    default public void setEDNS(int version) {
        this.setEDNS(version, 0, 0, Collections.emptyList());
    }

    public void setEDNS(int var1, int var2, int var3, List<EDNSOption> var4);

    default public void setEDNS(int version, int payloadSize, int flags, EDNSOption ... options) {
        this.setEDNS(version, payloadSize, flags, options == null ? Collections.emptyList() : Arrays.asList(options));
    }

    public void setTSIGKey(TSIG var1);

    @Deprecated
    default public void setTimeout(int secs, int msecs) {
        this.setTimeout(Duration.ofMillis((long)secs * 1000L + (long)msecs));
    }

    @Deprecated
    default public void setTimeout(int secs) {
        this.setTimeout(Duration.ofSeconds(secs));
    }

    public void setTimeout(Duration var1);

    default public Duration getTimeout() {
        return Duration.ofSeconds(10L);
    }

    default public Message send(Message query) throws IOException {
        try {
            CompletableFuture<Message> result = this.sendAsync(query).toCompletableFuture();
            return result.get(this.getTimeout().toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e.getCause());
        }
        catch (TimeoutException e) {
            throw new IOException("Timed out while trying to resolve " + query.getQuestion().getName() + "/" + Type.string(query.getQuestion().type) + ", id=" + query.getHeader().getID(), e);
        }
    }

    default public CompletionStage<Message> sendAsync(Message query) {
        return this.sendAsync(query, ForkJoinPool.commonPool());
    }

    default public CompletionStage<Message> sendAsync(Message query, Executor executor) {
        final CompletableFuture<Message> f = new CompletableFuture<Message>();
        this.sendAsync(query, new ResolverListener(){

            @Override
            public void receiveMessage(Object id, Message m4) {
                f.complete(m4);
            }

            @Override
            public void handleException(Object id, Exception e) {
                f.completeExceptionally(e);
            }
        });
        return f;
    }

    @Deprecated
    default public Object sendAsync(Message query, ResolverListener listener) {
        Object id = new Object();
        CompletionStage<Message> f = this.sendAsync(query);
        f.handleAsync((result, throwable) -> {
            if (throwable != null) {
                Exception exception = throwable instanceof Exception ? (Exception)throwable : new Exception((Throwable)throwable);
                listener.handleException(id, exception);
                return null;
            }
            listener.receiveMessage(id, (Message)result);
            return null;
        });
        return id;
    }
}

