/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.xbill.DNS.Address;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Mnemonic;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Tokenizer;
import org.xbill.DNS.WireParseException;
import org.xbill.DNS.utils.base64;

public abstract class SVCBBase
extends Record {
    protected int svcPriority;
    protected Name targetName;
    protected final Map<Integer, ParameterBase> svcParams;
    public static final int MANDATORY = 0;
    public static final int ALPN = 1;
    public static final int NO_DEFAULT_ALPN = 2;
    public static final int PORT = 3;
    public static final int IPV4HINT = 4;
    public static final int ECH = 5;
    public static final int IPV6HINT = 6;
    @Deprecated
    public static final int ECHCONFIG = 5;
    private static final ParameterMnemonic parameters = new ParameterMnemonic();

    protected SVCBBase() {
        this.svcParams = new TreeMap<Integer, ParameterBase>();
    }

    protected SVCBBase(Name name, int type, int dclass, long ttl) {
        super(name, type, dclass, ttl);
        this.svcParams = new TreeMap<Integer, ParameterBase>();
    }

    protected SVCBBase(Name name, int type, int dclass, long ttl, int priority, Name domain, List<ParameterBase> params) {
        super(name, type, dclass, ttl);
        this.svcPriority = priority;
        this.targetName = domain;
        this.svcParams = new TreeMap<Integer, ParameterBase>();
        for (ParameterBase param : params) {
            if (this.svcParams.containsKey(param.getKey())) {
                throw new IllegalArgumentException("Duplicate SvcParam for key " + param.getKey());
            }
            this.svcParams.put(param.getKey(), param);
        }
    }

    public int getSvcPriority() {
        return this.svcPriority;
    }

    public Name getTargetName() {
        return this.targetName;
    }

    public Set<Integer> getSvcParamKeys() {
        return this.svcParams.keySet();
    }

    public ParameterBase getSvcParamValue(int key) {
        return this.svcParams.get(key);
    }

    protected boolean checkMandatoryParams() {
        ParameterMandatory param = (ParameterMandatory)this.getSvcParamValue(0);
        if (param != null) {
            Iterator iterator = param.values.iterator();
            while (iterator.hasNext()) {
                int key = (Integer)iterator.next();
                if (this.getSvcParamValue(key) != null) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    protected void rrFromWire(DNSInput in) throws IOException {
        this.svcPriority = in.readU16();
        this.targetName = new Name(in);
        this.svcParams.clear();
        while (in.remaining() >= 4) {
            int key = in.readU16();
            int length = in.readU16();
            byte[] value = in.readByteArray(length);
            Supplier<ParameterBase> factory = parameters.getFactory(key);
            ParameterBase param = factory != null ? factory.get() : new ParameterUnknown(key);
            param.fromWire(value);
            this.svcParams.put(key, param);
        }
        if (in.remaining() > 0) {
            throw new WireParseException("Record had unexpected number of bytes");
        }
        if (!this.checkMandatoryParams()) {
            throw new WireParseException("Not all mandatory SvcParams are specified");
        }
    }

    @Override
    protected String rrToString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.svcPriority);
        sb.append(" ");
        sb.append(this.targetName);
        for (Integer key : this.svcParams.keySet()) {
            sb.append(" ");
            sb.append(parameters.getText(key));
            ParameterBase param = this.svcParams.get(key);
            String value = param.toString();
            if (value == null || value.isEmpty()) continue;
            sb.append("=");
            sb.append(value);
        }
        return sb.toString();
    }

    @Override
    protected void rdataFromString(Tokenizer st, Name origin) throws IOException {
        this.svcPriority = st.getUInt16();
        this.targetName = st.getName(origin);
        this.svcParams.clear();
        while (true) {
            String keyStr = null;
            String valueStr = null;
            Tokenizer.Token t2 = st.get();
            if (!t2.isString()) break;
            int indexOfEquals = t2.value().indexOf(61);
            if (indexOfEquals == -1) {
                keyStr = t2.value();
            } else if (indexOfEquals == t2.value().length() - 1) {
                keyStr = t2.value().substring(0, indexOfEquals);
                Tokenizer.Token valueToken = st.get();
                if (!valueToken.isString()) {
                    throw new TextParseException("Expected value for parameter key '" + keyStr + "'");
                }
                valueStr = valueToken.value();
            } else if (indexOfEquals > 0) {
                keyStr = t2.value().substring(0, indexOfEquals);
                valueStr = t2.value().substring(indexOfEquals + 1);
            } else {
                throw new TextParseException("Expected valid parameter key=value for '" + t2.value() + "'");
            }
            int key = parameters.getValue(keyStr);
            if (key == -1) {
                throw new TextParseException("Expected a valid parameter key for '" + keyStr + "'");
            }
            if (this.svcParams.containsKey(key)) {
                throw new TextParseException("Duplicate parameter key for '" + keyStr + "'");
            }
            Supplier<ParameterBase> factory = parameters.getFactory(key);
            ParameterBase param = factory != null ? factory.get() : new ParameterUnknown(key);
            param.fromString(valueStr);
            this.svcParams.put(key, param);
        }
        st.unget();
        if (this.svcPriority == 0 && !this.svcParams.isEmpty()) {
            throw new TextParseException("No parameter values allowed for AliasMode");
        }
        if (!this.checkMandatoryParams()) {
            throw new TextParseException("Not all mandatory SvcParams are specified");
        }
    }

    @Override
    protected void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        out.writeU16(this.svcPriority);
        this.targetName.toWire(out, null, canonical);
        for (Integer key : this.svcParams.keySet()) {
            out.writeU16(key);
            ParameterBase param = this.svcParams.get(key);
            byte[] value = param.toWire();
            out.writeU16(value.length);
            out.writeByteArray(value);
        }
    }

    static {
        parameters.add(0, "mandatory", ParameterMandatory::new);
        parameters.add(1, "alpn", ParameterAlpn::new);
        parameters.add(2, "no-default-alpn", ParameterNoDefaultAlpn::new);
        parameters.add(3, "port", ParameterPort::new);
        parameters.add(4, "ipv4hint", ParameterIpv4Hint::new);
        parameters.add(5, "ech", ParameterEch::new);
        parameters.add(6, "ipv6hint", ParameterIpv6Hint::new);
        parameters.addAlias(5, "echconfig");
    }

    public static class ParameterUnknown
    extends ParameterBase {
        private final int key;
        private byte[] value;

        public ParameterUnknown(int key) {
            this.key = key;
            this.value = new byte[0];
        }

        public ParameterUnknown(int key, byte[] value) {
            this.key = key;
            this.value = value;
        }

        public byte[] getValue() {
            return this.value;
        }

        @Override
        public int getKey() {
            return this.key;
        }

        @Override
        public void fromWire(byte[] bytes) {
            this.value = bytes;
        }

        @Override
        public void fromString(String string) throws IOException {
            this.value = string == null || string.isEmpty() ? new byte[0] : Record.byteArrayFromString(string);
        }

        @Override
        public byte[] toWire() {
            return this.value;
        }

        @Override
        public String toString() {
            return Record.byteArrayToString(this.value, false);
        }
    }

    public static class ParameterIpv6Hint
    extends ParameterBase {
        private final List<byte[]> addresses;

        public ParameterIpv6Hint() {
            this.addresses = new ArrayList<byte[]>();
        }

        public ParameterIpv6Hint(List<Inet6Address> addresses) {
            this.addresses = addresses.stream().map(Inet6Address::getAddress).collect(Collectors.toList());
        }

        public List<Inet6Address> getAddresses() throws UnknownHostException {
            LinkedList<Inet6Address> addresses = new LinkedList<Inet6Address>();
            for (byte[] bytes : this.addresses) {
                InetAddress address = InetAddress.getByAddress(bytes);
                if (!(address instanceof Inet6Address)) continue;
                addresses.add((Inet6Address)address);
            }
            return addresses;
        }

        @Override
        public int getKey() {
            return 6;
        }

        @Override
        public void fromWire(byte[] bytes) throws IOException {
            this.addresses.clear();
            DNSInput in = new DNSInput(bytes);
            while (in.remaining() >= 16) {
                this.addresses.add(in.readByteArray(16));
            }
            if (in.remaining() > 0) {
                throw new WireParseException("Unexpected number of bytes in ipv6hint parameter");
            }
        }

        @Override
        public void fromString(String string) throws IOException {
            this.addresses.clear();
            if (string == null || string.isEmpty()) {
                throw new TextParseException("Non-empty IPv6 list must be specified for ipv6hint");
            }
            for (String str : string.split(",")) {
                byte[] address = Address.toByteArray(str, 2);
                if (address == null) {
                    throw new TextParseException("Invalid ipv6hint value '" + str + "'");
                }
                this.addresses.add(address);
            }
        }

        @Override
        public byte[] toWire() {
            DNSOutput out = new DNSOutput();
            for (byte[] b : this.addresses) {
                out.writeByteArray(b);
            }
            return out.toByteArray();
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (byte[] b : this.addresses) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                try {
                    InetAddress addr = InetAddress.getByAddress(null, b);
                    sb.append(addr.getHostAddress());
                }
                catch (UnknownHostException e) {
                    return e.getMessage();
                }
            }
            return sb.toString();
        }
    }

    @Deprecated
    public static class ParameterEchConfig
    extends ParameterBase {
        private byte[] data;

        public ParameterEchConfig() {
        }

        public ParameterEchConfig(byte[] data) {
            this.data = data;
        }

        public byte[] getData() {
            return this.data;
        }

        @Override
        public int getKey() {
            return 5;
        }

        @Override
        public void fromWire(byte[] bytes) {
            this.data = bytes;
        }

        @Override
        public void fromString(String string) throws TextParseException {
            if (string == null || string.isEmpty()) {
                throw new TextParseException("Non-empty base64 value must be specified for echconfig");
            }
            this.data = base64.fromString(string);
        }

        @Override
        public byte[] toWire() {
            return this.data;
        }

        @Override
        public String toString() {
            return base64.toString(this.data);
        }
    }

    public static class ParameterEch
    extends ParameterBase {
        private byte[] data;

        public ParameterEch() {
        }

        public ParameterEch(byte[] data) {
            this.data = data;
        }

        public byte[] getData() {
            return this.data;
        }

        @Override
        public int getKey() {
            return 5;
        }

        @Override
        public void fromWire(byte[] bytes) {
            this.data = bytes;
        }

        @Override
        public void fromString(String string) throws TextParseException {
            if (string == null || string.isEmpty()) {
                throw new TextParseException("Non-empty base64 value must be specified for ech");
            }
            this.data = base64.fromString(string);
        }

        @Override
        public byte[] toWire() {
            return this.data;
        }

        @Override
        public String toString() {
            return base64.toString(this.data);
        }
    }

    public static class ParameterIpv4Hint
    extends ParameterBase {
        private final List<byte[]> addresses;

        public ParameterIpv4Hint() {
            this.addresses = new ArrayList<byte[]>();
        }

        public ParameterIpv4Hint(List<Inet4Address> addresses) {
            this.addresses = addresses.stream().map(Inet4Address::getAddress).collect(Collectors.toList());
        }

        public List<Inet4Address> getAddresses() throws UnknownHostException {
            LinkedList<Inet4Address> addresses = new LinkedList<Inet4Address>();
            for (byte[] bytes : this.addresses) {
                InetAddress address = InetAddress.getByAddress(bytes);
                if (!(address instanceof Inet4Address)) continue;
                addresses.add((Inet4Address)address);
            }
            return addresses;
        }

        @Override
        public int getKey() {
            return 4;
        }

        @Override
        public void fromWire(byte[] bytes) throws IOException {
            this.addresses.clear();
            DNSInput in = new DNSInput(bytes);
            while (in.remaining() >= 4) {
                this.addresses.add(in.readByteArray(4));
            }
            if (in.remaining() > 0) {
                throw new WireParseException("Unexpected number of bytes in ipv4hint parameter");
            }
        }

        @Override
        public void fromString(String string) throws IOException {
            this.addresses.clear();
            if (string == null || string.isEmpty()) {
                throw new TextParseException("Non-empty IPv4 list must be specified for ipv4hint");
            }
            for (String str : string.split(",")) {
                byte[] address = Address.toByteArray(str, 1);
                if (address == null) {
                    throw new TextParseException("Invalid ipv4hint value '" + str + "'");
                }
                this.addresses.add(address);
            }
        }

        @Override
        public byte[] toWire() {
            DNSOutput out = new DNSOutput();
            for (byte[] b : this.addresses) {
                out.writeByteArray(b);
            }
            return out.toByteArray();
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (byte[] b : this.addresses) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(Address.toDottedQuad(b));
            }
            return sb.toString();
        }
    }

    public static class ParameterPort
    extends ParameterBase {
        private int port;

        public ParameterPort() {
        }

        public ParameterPort(int port) {
            this.port = port;
        }

        public int getPort() {
            return this.port;
        }

        @Override
        public int getKey() {
            return 3;
        }

        @Override
        public void fromWire(byte[] bytes) throws IOException {
            DNSInput in = new DNSInput(bytes);
            this.port = in.readU16();
            if (in.remaining() > 0) {
                throw new WireParseException("Unexpected number of bytes in port parameter");
            }
        }

        @Override
        public void fromString(String string) throws TextParseException {
            if (string == null || string.isEmpty()) {
                throw new TextParseException("Integer value must be specified for port");
            }
            this.port = Integer.parseInt(string);
        }

        @Override
        public byte[] toWire() {
            DNSOutput out = new DNSOutput();
            out.writeU16(this.port);
            return out.toByteArray();
        }

        @Override
        public String toString() {
            return Integer.toString(this.port);
        }
    }

    public static class ParameterNoDefaultAlpn
    extends ParameterBase {
        @Override
        public int getKey() {
            return 2;
        }

        @Override
        public void fromWire(byte[] bytes) throws WireParseException {
            if (bytes.length > 0) {
                throw new WireParseException("No value can be specified for no-default-alpn");
            }
        }

        @Override
        public void fromString(String string) throws TextParseException {
            if (string != null && !string.isEmpty()) {
                throw new TextParseException("No value can be specified for no-default-alpn");
            }
        }

        @Override
        public byte[] toWire() {
            return new byte[0];
        }

        @Override
        public String toString() {
            return "";
        }
    }

    public static class ParameterAlpn
    extends ParameterBase {
        private final List<byte[]> values = new ArrayList<byte[]>();

        public ParameterAlpn() {
        }

        public ParameterAlpn(List<String> values) throws TextParseException {
            for (String str : values) {
                this.values.add(Record.byteArrayFromString(str));
            }
        }

        public List<String> getValues() {
            ArrayList<String> values = new ArrayList<String>();
            for (byte[] b : this.values) {
                values.add(Record.byteArrayToString(b, false));
            }
            return values;
        }

        @Override
        public int getKey() {
            return 1;
        }

        @Override
        public void fromWire(byte[] bytes) throws IOException {
            this.values.clear();
            DNSInput in = new DNSInput(bytes);
            while (in.remaining() > 0) {
                byte[] b = in.readCountedString();
                this.values.add(b);
            }
        }

        @Override
        public void fromString(String string) throws TextParseException {
            this.values.clear();
            if (string == null || string.isEmpty()) {
                throw new TextParseException("Non-empty list must be specified for alpn");
            }
            for (String str : ParameterAlpn.splitStringWithEscapedCommas(string)) {
                this.values.add(Record.byteArrayFromString(str));
            }
        }

        @Override
        public byte[] toWire() {
            DNSOutput out = new DNSOutput();
            for (byte[] b : this.values) {
                out.writeCountedString(b);
            }
            return out.toByteArray();
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (byte[] b : this.values) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                String str = Record.byteArrayToString(b, false);
                str = str.replaceAll(",", "\\\\,");
                sb.append(str);
            }
            return sb.toString();
        }
    }

    public static class ParameterMandatory
    extends ParameterBase {
        private final List<Integer> values;

        public ParameterMandatory() {
            this.values = new ArrayList<Integer>();
        }

        public ParameterMandatory(List<Integer> values) {
            this.values = values;
        }

        public List<Integer> getValues() {
            return this.values;
        }

        @Override
        public int getKey() {
            return 0;
        }

        @Override
        public void fromWire(byte[] bytes) throws IOException {
            this.values.clear();
            DNSInput in = new DNSInput(bytes);
            while (in.remaining() >= 2) {
                int key = in.readU16();
                this.values.add(key);
            }
            if (in.remaining() > 0) {
                throw new WireParseException("Unexpected number of bytes in mandatory parameter");
            }
        }

        @Override
        public void fromString(String string) throws TextParseException {
            this.values.clear();
            if (string == null || string.isEmpty()) {
                throw new TextParseException("Non-empty list must be specified for mandatory");
            }
            for (String str : ParameterMandatory.splitStringWithEscapedCommas(string)) {
                int key = parameters.getValue(str);
                if (key == 0) {
                    throw new TextParseException("Key mandatory must not appear in its own list");
                }
                if (this.values.contains(key)) {
                    throw new TextParseException("Duplicate key " + str + " not allowed in mandatory list");
                }
                this.values.add(key);
            }
        }

        @Override
        public byte[] toWire() {
            DNSOutput out = new DNSOutput();
            for (Integer val : this.values) {
                out.writeU16(val);
            }
            return out.toByteArray();
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (Integer val : this.values) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(parameters.getText(val));
            }
            return sb.toString();
        }
    }

    public static abstract class ParameterBase {
        public abstract int getKey();

        public abstract void fromWire(byte[] var1) throws IOException;

        public abstract void fromString(String var1) throws IOException;

        public abstract byte[] toWire();

        public abstract String toString();

        public static String[] splitStringWithEscapedCommas(String string) {
            return string.split("(?<!\\\\),");
        }
    }

    private static class ParameterMnemonic
    extends Mnemonic {
        private final HashMap<Integer, Supplier<ParameterBase>> factories;

        public ParameterMnemonic() {
            super("SVCB/HTTPS Parameters", 3);
            this.setPrefix("key");
            this.setNumericAllowed(true);
            this.setMaximum(65535);
            this.factories = new HashMap();
        }

        public void add(int val, String str, Supplier<ParameterBase> factory) {
            super.add(val, str);
            this.factories.put(val, factory);
        }

        public Supplier<ParameterBase> getFactory(int val) {
            return this.factories.get(val);
        }
    }
}

